package com.esign.sdk

import android.content.DialogInterface
import android.os.Bundle
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import com.esign.facesdk.EsignSDK
import com.esign.facesdk.data.Config
import com.esign.facesdk.net.response.FaceResultResponse
import com.esign.facesdk.net.response.InitResponse
import com.esign.sdk.databinding.ActivityDemoBinding


class MainActivity : AppCompatActivity(){

    private lateinit var binding: ActivityDemoBinding


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityDemoBinding.inflate(layoutInflater)
        setContentView(binding.root)
        var config = Config()

        // 初始化，以下配置为沙箱环境demo的测试key和license，如果开发者在自己的项目里需要替换自己包名对应的key和license
        config.key = "s_be282bccf214541417b6c5f999850857"
        config.license = "s_sJKAbPJB9u3bWLak1IVMzVjlusmUzziCxdGB+yr+CoqSo5tHi6KD0a/LNMEibNiDEaObXkeIX8layAzCApgZvvCZKaFxkz7vkIRG/wxfghP1Q9K7ai4n86I7nVlEhEdf9QovCHAO5Ax717IwYaijgHeW/YXGqbk6cdZglE+xVSoyoSCJokIqlajugj7luqR9lZtaPO6Tvz9eZAWqrR4I+CuunQEgsH+oRvEjkBDxxoj4SwBX4YsT1jKJQtBGTgh8KORxuJV2dbM0TwcoXg2x5oZEgYqVmWPP3WfsFd65oU/pGgTD7it70LPhaQkPVU1Ofxcm0KcGRAYac4CR6MsZF7ScuOWUHDk2vJ8rJTQ37y2jKq0Z5Cpo54XIyxX48lJbKvXHDZoJelGDhM4Ol6BUoKLtuyZDQvDFI6DzYCM3tjEjxYZF8b5qFmqTjZbdexZEmVirGoTRySuLzlK4KCarDtl6kv8SVOoJxZWmaRjZXk4H0+haeHLfew3pTNubVmelmNZeCcAx0qbziyWDXukjK/9Kc1tagy1jQ2L0ysDuosL3mJOaoq5MoftmXKhWm1qdmYQG1eu8Q8BW2rd+Wi/LdCcBXomGKvHRDfV4IVs89DL3v3SF6zxi1uEW8ie4PkNqxhqUYhXUFEehHt3Clfe5u+tEEoEEndGb40W2R/sCS9MahqGfcjgTSjgLoR9GcYFCujdi9fvrFazBYmqLu3aRTq78TUEZa5UhSVu/Iqc7uwfbnoL9P1tBvpKnDjQBkoOt"


        binding.init.setOnClickListener {

            EsignSDK.getInstance().init(this, config, object : EsignSDK.InitCallback {
                override fun onInitResult(result: InitResponse) {
                    if (result.success){

                        showResultDialog("初始化成功")
                    }else{
                        showResultDialog("初始化失败:${result.code} ${result.msg}")
                    }
                }

            })
        }

        binding.vertify.setOnClickListener {

            if (binding.face.text.isNullOrEmpty()){
                Toast.makeText(this,"请输入faceAuthCode",Toast.LENGTH_SHORT).show()
                return@setOnClickListener
            }

            EsignSDK.getInstance().faceVerify(binding.face.text.toString(),
                object : EsignSDK.FaceVerifyCallback {
                    override fun onFaceResult(
                        result:FaceResultResponse
                    ) {
                        if (result?.passed == true){
                            showResultDialog("刷脸已经通过")
                            return
                        }
                        showResultDialog("刷脸失败 errCode:${result.errCode}  msg:${result.msg}")
                    }
                })
        }
    }

    private fun showResultDialog(s: String) {
        val builder = AlertDialog.Builder(this);
        builder.setTitle("提示")
        builder.setMessage(s)

        val dialogClickListener = DialogInterface.OnClickListener { _, which ->
            when (which) {
                DialogInterface.BUTTON_POSITIVE -> {

                }
                DialogInterface.BUTTON_NEGATIVE -> {
                }
            }
        }
        builder.setPositiveButton("好的", dialogClickListener)
        builder.create().show();

    }
}
