/*
 * Decompiled with CFR 0.152.
 */
package com.esign.retrofit2;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.esign.okhttp3.Call;
import com.esign.okhttp3.MediaType;
import com.esign.okhttp3.Request;
import com.esign.okhttp3.ResponseBody;
import com.esign.retrofit2.Call;
import com.esign.retrofit2.Callback;
import com.esign.retrofit2.Converter;
import com.esign.retrofit2.RequestFactory;
import com.esign.retrofit2.Response;
import com.esign.retrofit2.Utils;
import java.io.IOException;
import java.util.Objects;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import okio.Timeout;

final class OkHttpCall<T>
implements Call<T> {
    private final RequestFactory requestFactory;
    private final Object[] args;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, T> responseConverter;
    private volatile boolean canceled;
    @GuardedBy(value="this")
    @Nullable
    private com.esign.okhttp3.Call rawCall;
    @GuardedBy(value="this")
    @Nullable
    private Throwable creationFailure;
    @GuardedBy(value="this")
    private boolean executed;

    OkHttpCall(RequestFactory requestFactory, Object[] args, Call.Factory callFactory, Converter<ResponseBody, T> responseConverter) {
        this.requestFactory = requestFactory;
        this.args = args;
        this.callFactory = callFactory;
        this.responseConverter = responseConverter;
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.requestFactory, this.args, this.callFactory, this.responseConverter);
    }

    @Override
    public synchronized Request request() {
        try {
            return this.getRawCall().request();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create request.", e);
        }
    }

    @Override
    public synchronized Timeout timeout() {
        try {
            return this.getRawCall().timeout();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create call.", e);
        }
    }

    @GuardedBy(value="this")
    private com.esign.okhttp3.Call getRawCall() throws IOException {
        com.esign.okhttp3.Call call = this.rawCall;
        if (call != null) {
            return call;
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw (IOException)this.creationFailure;
            }
            if (this.creationFailure instanceof RuntimeException) {
                throw (RuntimeException)this.creationFailure;
            }
            throw (Error)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall;
        }
        catch (IOException | Error | RuntimeException e) {
            Utils.throwIfFatal(e);
            this.creationFailure = e;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<T> callback) {
        Throwable failure;
        com.esign.okhttp3.Call call;
        Objects.requireNonNull(callback, "callback == null");
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall;
            failure = this.creationFailure;
            if (call == null && failure == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    failure = this.creationFailure = t;
                }
            }
        }
        if (failure != null) {
            callback.onFailure(this, failure);
            return;
        }
        if (this.canceled) {
            call.cancel();
        }
        call.enqueue(new com.esign.okhttp3.Callback(){

            @Override
            public void onResponse(com.esign.okhttp3.Call call, com.esign.okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    Utils.throwIfFatal(e);
                    this.callFailure(e);
                    return;
                }
                try {
                    callback.onResponse(OkHttpCall.this, response);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }

            @Override
            public void onFailure(com.esign.okhttp3.Call call, IOException e) {
                this.callFailure(e);
            }

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(OkHttpCall.this, e);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        com.esign.okhttp3.Call call;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.getRawCall();
        }
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    private com.esign.okhttp3.Call createRawCall() throws IOException {
        com.esign.okhttp3.Call call = this.callFactory.newCall(this.requestFactory.create(this.args));
        if (call == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response<T> parseResponse(com.esign.okhttp3.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body(new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = Utils.buffer(rawBody);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            rawBody.close();
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            return Response.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        com.esign.okhttp3.Call call;
        this.canceled = true;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call = this.rawCall;
        }
        if (call != null) {
            call.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private final BufferedSource delegateSource;
        @Nullable
        IOException thrownException;

        ExceptionCatchingResponseBody(ResponseBody delegate) {
            this.delegate = delegate;
            this.delegateSource = Okio.buffer((Source)new ForwardingSource((Source)delegate.source()){

                public long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        thrownException = e;
                        throw e;
                    }
                }
            });
        }

        @Override
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        @Override
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override
        public BufferedSource source() {
            return this.delegateSource;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

