/*
 * Decompiled with CFR 0.152.
 */
package com.esign.retrofit2.adapter.rxjava2;

import com.esign.retrofit2.Call;
import com.esign.retrofit2.Callback;
import com.esign.retrofit2.Response;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;

final class CallEnqueueObservable<T>
extends Observable<Response<T>> {
    private final Call<T> originalCall;

    CallEnqueueObservable(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    protected void subscribeActual(Observer<? super Response<T>> observer) {
        Call call = this.originalCall.clone();
        CallCallback callback = new CallCallback(call, observer);
        observer.onSubscribe(callback);
        if (!callback.isDisposed()) {
            call.enqueue(callback);
        }
    }

    private static final class CallCallback<T>
    implements Disposable,
    Callback<T> {
        private final Call<?> call;
        private final Observer<? super Response<T>> observer;
        private volatile boolean disposed;
        boolean terminated = false;

        CallCallback(Call<?> call, Observer<? super Response<T>> observer) {
            this.call = call;
            this.observer = observer;
        }

        @Override
        public void onResponse(Call<T> call, Response<T> response) {
            block7: {
                if (this.disposed) {
                    return;
                }
                try {
                    this.observer.onNext(response);
                    if (!this.disposed) {
                        this.terminated = true;
                        this.observer.onComplete();
                    }
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal((Throwable)t);
                    if (this.terminated) {
                        RxJavaPlugins.onError((Throwable)t);
                    }
                    if (this.disposed) break block7;
                    try {
                        this.observer.onError(t);
                    }
                    catch (Throwable inner) {
                        Exceptions.throwIfFatal((Throwable)inner);
                        RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                    }
                }
            }
        }

        @Override
        public void onFailure(Call<T> call, Throwable t) {
            if (call.isCanceled()) {
                return;
            }
            try {
                this.observer.onError(t);
            }
            catch (Throwable inner) {
                Exceptions.throwIfFatal((Throwable)inner);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
            }
        }

        public void dispose() {
            this.disposed = true;
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

