/*
 * Decompiled with CFR 0.152.
 */
package com.esign.retrofit2.adapter.rxjava2;

import com.esign.retrofit2.Call;
import com.esign.retrofit2.Response;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;

final class CallExecuteObservable<T>
extends Observable<Response<T>> {
    private final Call<T> originalCall;

    CallExecuteObservable(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    protected void subscribeActual(Observer<? super Response<T>> observer) {
        block8: {
            Call<T> call = this.originalCall.clone();
            CallDisposable disposable = new CallDisposable(call);
            observer.onSubscribe((Disposable)disposable);
            if (disposable.isDisposed()) {
                return;
            }
            boolean terminated = false;
            try {
                Response<T> response = call.execute();
                if (!disposable.isDisposed()) {
                    observer.onNext(response);
                }
                if (!disposable.isDisposed()) {
                    terminated = true;
                    observer.onComplete();
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                if (terminated) {
                    RxJavaPlugins.onError((Throwable)t);
                }
                if (disposable.isDisposed()) break block8;
                try {
                    observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                }
            }
        }
    }

    private static final class CallDisposable
    implements Disposable {
        private final Call<?> call;
        private volatile boolean disposed;

        CallDisposable(Call<?> call) {
            this.call = call;
        }

        public void dispose() {
            this.disposed = true;
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

