/*
 * Decompiled with CFR 0.152.
 */
package com.esign.retrofit2.adapter.rxjava2;

import androidx.annotation.Nullable;
import com.esign.retrofit2.Response;

public final class Result<T> {
    @Nullable
    private final Response<T> response;
    @Nullable
    private final Throwable error;

    public static <T> Result<T> error(Throwable error) {
        if (error == null) {
            throw new NullPointerException("error == null");
        }
        return new Result<T>(null, error);
    }

    public static <T> Result<T> response(Response<T> response) {
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        return new Result<T>(response, null);
    }

    private Result(@Nullable Response<T> response, @Nullable Throwable error) {
        this.response = response;
        this.error = error;
    }

    @Nullable
    public Response<T> response() {
        return this.response;
    }

    @Nullable
    public Throwable error() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }
}

