/*
 * Decompiled with CFR 0.152.
 */
package com.esign.retrofit2.adapter.rxjava2;

import com.esign.retrofit2.Response;
import com.esign.retrofit2.adapter.rxjava2.Result;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;

final class ResultObservable<T>
extends Observable<Result<T>> {
    private final Observable<Response<T>> upstream;

    ResultObservable(Observable<Response<T>> upstream) {
        this.upstream = upstream;
    }

    protected void subscribeActual(Observer<? super Result<T>> observer) {
        this.upstream.subscribe(new ResultObserver(observer));
    }

    private static class ResultObserver<R>
    implements Observer<Response<R>> {
        private final Observer<? super Result<R>> observer;

        ResultObserver(Observer<? super Result<R>> observer) {
            this.observer = observer;
        }

        public void onSubscribe(Disposable disposable) {
            this.observer.onSubscribe(disposable);
        }

        public void onNext(Response<R> response) {
            this.observer.onNext(Result.response(response));
        }

        public void onError(Throwable throwable) {
            try {
                this.observer.onNext(Result.error(throwable));
            }
            catch (Throwable t) {
                try {
                    this.observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                }
                return;
            }
            this.observer.onComplete();
        }

        public void onComplete() {
            this.observer.onComplete();
        }
    }
}

