
#指定代码的压缩级别
-optimizationpasses 5

# 指定不去忽略非公共的库的类的成员
-dontskipnonpubliclibraryclassmembers

# 有了verbose这句话，混淆后就会生成映射文件
# 包含有类名->混淆后类名的映射关系
# 然后使用printmapping指定映射文件的名称
-verbose
-printmapping priguardMapping.txt


# 指定混淆时采用的算法，后面的参数是一个过滤器
# 这个过滤器是谷歌推荐的算法，一般不改变
-optimizations !code/simplification/arithmetic,!field/*,!class/merging/*

# 抛出异常时保留代码行号
-keepattributes SourceFile,LineNumberTable
#不混淆内部类
-keepattributes InnerClasses

# 枚举类不能被混淆
-keepclassmembers enum * {
    public static **[] values();
    public static ** valueOf(java.lang.String);
}

#人脸识别sdk的混淆规则



######################云产品依赖的第三方库 混淆规则-BEGIN###########################

## support:appcompat-v7
-keep public class android.support.v7.widget.** { *; }
-keep public class android.support.v7.internal.widget.** { *; }
-keep public class android.support.v7.internal.view.menu.** { *; }

-keep public class * extends android.support.v4.view.ActionProvider {
    public <init>(android.content.Context);
}

##########################云产品依赖的第三方库 混淆规则-END##############################


#apk 包内所有 class 的内部结构
-dump class_files.txt
#未混淆的类和成员
-printseeds seeds.txt
#列出从 apk 中删除的代码
-printusage unused.txt

#不混淆内部类
-keepattributes InnerClasses

#不混淆jni调用类
-keepclasseswithmembers class *{
    native <methods>;
}

###################### faceverify-BEGIN ###########################
-ignorewarnings
-keep public class com.tencent.ytcommon.**{*;}

-keep class com.tencent.turingface.sdk.*.TNative$aa { public *; }
-keep class com.tencent.turingface.sdk.*.TNative$aa$bb { public *; }
-keep class com.tencent.turingcam.** {*;}

-keep public class com.tencent.youtu.ytagreflectlivecheck.jni.**{*;}
-keep public class com.tencent.youtu.ytagreflectlivecheck.YTAGReflectLiveCheckInterface{
    public <methods>;
}
-keep public class com.tencent.youtu.ytposedetect.jni.**{*;}
-keep public class com.tencent.youtu.ytposedetect.data.**{*;}
-keep public class com.tencent.youtu.liveness.YTDeviceInfo{*;}
-keep public class com.tencent.youtu.liveness.YTFaceTracker{*;}
-keep public class com.tencent.youtu.liveness.YTFaceTracker$*{*;}
-keep public class com.tencent.youtu.sdkkitframework.liveness.framework.YtSDKKitFrameworkTool{
   public *;
}
-keep public class com.tencent.youtu.sdkkitframework.liveness.common.YTImageData{
   *;
}
-keep public class com.tencent.cloud.huiyansdkface.facelight.net.*$*{
    *;
}
-keep public class com.tencent.cloud.huiyansdkface.facelight.net.**{
    *;
}
-keep public class com.tencent.cloud.huiyansdkface.facelight.provider.WbDeviceRiskInfo{
    public <fields>;
}
-keep public class com.tencent.cloud.huiyansdkface.facelight.provider.WbUiTips{
    *;
}

#================数据上报混淆规则 start===========================
#实体类
-keep class com.tencent.cloud.huiyansdkface.analytics.EventSender{
    *;
}
-keep class com.tencent.cloud.huiyansdkface.analytics.EventSender$*{
    *;
}
-keep class com.tencent.cloud.huiyansdkface.analytics.WBSAEvent{
     *;
}
-keep class com.tencent.cloud.huiyansdkface.analytics.WBSAParam{
     *;
}
#================数据上报混淆规则 end===========================

#######################faceverify-END#############################

####################### normal混淆规则-BEGIN#############################
#不混淆内部类
-keepattributes InnerClasses
-keepattributes *Annotation*
-keepattributes Signature
-keepattributes Exceptions

-keep public class com.tencent.cloud.huiyansdkface.normal.net.*$*{
    *;
}
-keep public class com.tencent.cloud.huiyansdkface.normal.net.*{
    *;
}
#bugly
-keep class com.tencent.bugly.idasc.**{
    *;
}
#wehttp混淆规则
-dontwarn com.tencent.cloud.huiyansdkface.okio.**
-keep class com.tencent.cloud.huiyansdkface.okio.**{
    *;
}
-dontwarn com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient$Builder

####################### normal混淆规则-END#############################

##---------------Begin: proguard configuration for Gson  ----------
# Gson uses generic type information stored in a class file when working with fields. Proguard
# removes such information by default, so configure it to keep all of it.
-keepattributes Signature

# For using GSON @Expose annotation
-keepattributes *Annotation*

# Gson specific classes
-keep class sun.misc.Unsafe { *; }
#-keep class com.google.gson.stream.** { *; }

# Application classes that will be serialized/deserialized over Gson
-keep class com.google.gson.examples.android.model.** { *; }
# Gson
-keep class com.google.gson.** { *; }
-keep class sun.misc.Unsafe { *; }
-keep class com.google.gson.stream.** { *; }

##---------------End: proguard configuration for Gson  ----------

# Retrofit
-keep class com.esign.retrofit2.** { *; }
-keepattributes Signature
-keepattributes Exceptions

# RxJava
-dontwarn rx.**
-keep class rx.schedulers.Schedulers {
    public static <methods>;
}
-keep class rx.schedulers.ImmediateScheduler {
    public <methods>;
}
-keep class rx.internal.util.RxRunnable {
    public <methods>;
}

# RxAndroid
-keep class rx.android.schedulers.AndroidSchedulers {
    public static <methods>;
}
-keep class rx.android.schedulers.HandlerScheduler {
    public <methods>;
}
-keep class rx.android.schedulers.LooperScheduler {
    public <methods>;
}

# OkHttp
-keep class com.esign.okhttp3.** { *; }
-keep interface com.esign.okhttp3.** { *; }
-dontwarn com.esign.okhttp3.**

-keep public class con.esign.esignsdk.R$*{
public static final int *;
}

-keep class cn.esign.base.base.**{*;}
-keep public class * extends android.app.Activity{
	public <fields>;
	public <methods>;
}
-keep class com.esign.base.net.RetrofitManager { *; }
-keep class com.esign.esignsdk.data.** { *; }
-keep class com.google.gson.stream.** { *; }




-keep class com.esign.base.base.BaseActivity {
    *;
}



# Application classes that will be serialized/deserialized over Gson 下面替换成自己的实体类

-keep class com.esign.facesdk.EsignSdk {
 public static int REQUEST_CODE_H5;
 public static com.esign.facesdk.EsignSdk getInstance();
 public void init(android.app.Activity, com.esign.facesdk.data.Config,com.esign.facesdk.EsignSDK.InitCallback);
 public void faceVerify(java.lang.String, com.esign.facesdk.EsignSDK.FaceVerifyCallback);
}
-keep class com.esign.facesdk.data.** { *; }
-keep class com.esign.facesdk.net.request.** {*;}
-keep class com.esign.facesdk.net.response.** {*;}
-keep class com.esign.facesdk.net.BaseDTO {*;}

-dontwarn sun.misc.**

-keepclassmembers class rx.internal.util.unsafe.*ArrayQueue*Field* {
   long producerIndex;
   long consumerIndex;
}

-keepclassmembers class rx.internal.util.unsafe.BaseLinkedQueueProducerNodeRef {
    rx.internal.util.atomic.LinkedQueueNode producerNode;
}

-keepclassmembers class rx.internal.util.unsafe.BaseLinkedQueueConsumerNodeRef {
    rx.internal.util.atomic.LinkedQueueNode consumerNode;
}

-dontnote rx.internal.util.PlatformDependent

-keep class io.reactivex.** { *; }
-keep class retrofit.** { *; }
-keep class com.squareup.** { *; }
-keep class rx.** { *; }
-keepclassmembers class * implements io.reactivex.annotations.Nullable { *; }
-keepclassmembers class * extends io.reactivex.annotations.Nullable { *; }
-keepclassmembers class * implements io.reactivex.annotations.CheckReturnValue { *; }
-keepclassmembers class * extends io.reactivex.annotations.CheckReturnValue { *; }
-keepclassmembers class * implements io.reactivex.functions.Function { *; }
-keepclassmembers class * extends io.reactivex.functions.Function { *; }
-keepclassmembers class * implements io.reactivex.functions.Consumer { *; }
-keepclassmembers class * extends io.reactivex.functions.Consumer { *; }
-keepclassmembers class * extends io.reactivex.android.** { *; }



