package com.esign.sdk

import android.content.DialogInterface
import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import com.esign.facesdk.EsignSDK
import com.esign.facesdk.data.Config
import com.esign.facesdk.net.response.FaceResultResponse
import com.esign.facesdk.net.response.InitResponse
import com.esign.sdk.databinding.ActivityDemoBinding


class MainActivity : AppCompatActivity(){

    private lateinit var binding: ActivityDemoBinding


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityDemoBinding.inflate(layoutInflater)
        setContentView(binding.root)
        var config = Config()



        binding.key.setText("")
        binding.lincese.setText("")
        binding.init.setOnClickListener {

            if (binding.key.text.isNullOrEmpty()){
                Toast.makeText(this,"请输入key",Toast.LENGTH_SHORT).show()
                return@setOnClickListener
            }

            config.key = binding.key.text.toString()

            if (binding.lincese.text.isNullOrEmpty()){
                Toast.makeText(this,"请输入lincese",Toast.LENGTH_SHORT).show()
                return@setOnClickListener
            }
            config.license = binding.lincese.text.toString()

            if (binding.group.text.isNotEmpty()){
                EsignSDK.group = binding.group.text.toString()
            }

            Log.e("test","${binding.sw.isChecked}")
            config.isLandScape = binding.sw.isChecked

            EsignSDK.getInstance().init(this, config, object : EsignSDK.InitCallback {
                override fun onInitResult(result: InitResponse) {
                    if (result.success){

                        showResultDialog("初始化成功")
                    }else{
                        showResultDialog("初始化失败:${result.code} ${result.msg}")
                    }
                }

            })
        }

        binding.vertify.setOnClickListener {

            if (binding.face.text.isNullOrEmpty()){
                Toast.makeText(this,"请输入faceAuthCode",Toast.LENGTH_SHORT).show()
                return@setOnClickListener
            }

            EsignSDK.getInstance().faceVerify(binding.face.text.toString(),
                object : EsignSDK.FaceVerifyCallback {
                    override fun onFaceResult(
                        result:FaceResultResponse
                    ) {
                        if (result?.passed == true){
                            showResultDialog("刷脸已经通过")
                            return
                        }
                        showResultDialog("刷脸失败 errCode:${result.errCode}  msg:${result.msg}")
                    }
                })
        }
    }

    private fun showResultDialog(s: String) {
        val builder = AlertDialog.Builder(this);
        builder.setTitle("提示")
        builder.setMessage(s)

        val dialogClickListener = DialogInterface.OnClickListener { _, which ->
            when (which) {
                DialogInterface.BUTTON_POSITIVE -> {

                }
                DialogInterface.BUTTON_NEGATIVE -> {
                }
            }
        }
        builder.setPositiveButton("好的", dialogClickListener)
        builder.create().show();

    }
}
