if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface DemoPage_Params {
    TAG?: string;
    licenseKey?: string;
    license?: string;
    faceCode?: string;
}
import { EsignSDK } from "@normalized:N&&&esignfacesdk/Index&1.0.0";
import type { FaceResultResponse, InitResponse } from "@normalized:N&&&esignfacesdk/Index&1.0.0";
import promptAction from "@ohos:promptAction";
import type common from "@ohos:app.ability.common";
function __TextInput__inputStyle(): void {
    TextInput.width('100%');
    TextInput.height({ "id": 16777270, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
    TextInput.fontColor(Color.Black);
    TextInput.maxLines(1);
    TextInput.placeholderColor({ "id": 16777236, "type": 10001, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
}
class DemoPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.TAG = 'DemoPage';
        this.__licenseKey = new ObservedPropertySimplePU('', this, "licenseKey");
        this.__license = new ObservedPropertySimplePU('', this, "license");
        this.__faceCode = new ObservedPropertySimplePU('', this, "faceCode");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: DemoPage_Params) {
        if (params.TAG !== undefined) {
            this.TAG = params.TAG;
        }
        if (params.licenseKey !== undefined) {
            this.licenseKey = params.licenseKey;
        }
        if (params.license !== undefined) {
            this.license = params.license;
        }
        if (params.faceCode !== undefined) {
            this.faceCode = params.faceCode;
        }
    }
    updateStateVars(params: DemoPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__licenseKey.purgeDependencyOnElmtId(rmElmtId);
        this.__license.purgeDependencyOnElmtId(rmElmtId);
        this.__faceCode.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__licenseKey.aboutToBeDeleted();
        this.__license.aboutToBeDeleted();
        this.__faceCode.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private TAG: string;
    private __licenseKey: ObservedPropertySimplePU<string>;
    get licenseKey() {
        return this.__licenseKey.get();
    }
    set licenseKey(newValue: string) {
        this.__licenseKey.set(newValue);
    }
    private __license: ObservedPropertySimplePU<string>;
    get license() {
        return this.__license.get();
    }
    set license(newValue: string) {
        this.__license.set(newValue);
    }
    private __faceCode: ObservedPropertySimplePU<string>;
    get faceCode() {
        return this.__faceCode.get();
    }
    set faceCode(newValue: string) {
        this.__faceCode.set(newValue);
    }
    async aboutToAppear() {
        console.info(this.TAG, "aboutToAppear");
    }
    onBackPress() {
        console.debug(this.TAG, 'demo onBackPress');
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.backgroundColor(Color.White);
            Column.height('100%');
            Column.width('100%');
            Column.padding({
                left: { "id": 16777287, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" },
                right: { "id": 16777287, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" },
                bottom: { "id": 16777273, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }
            });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777319, "type": 20000, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Image.width('58vp');
            Image.margin({ top: { "id": 16777265, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" } });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create({ "id": 16777225, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.width('100%');
            Text.height({ "id": 16777270, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.fontColor(Color.Black);
            Text.maxLines(1);
            Text.margin({ top: { "id": 16777265, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" } });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            TextInput.create({ placeholder: { "id": 16777225, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, text: 's_be282bccf214541417b6c5f999850857' });
            TextInput.onChange((value: string) => {
                this.licenseKey = value;
            });
            __TextInput__inputStyle();
        }, TextInput);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create({ "id": 16777222, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.width('100%');
            Text.height({ "id": 16777270, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.fontColor(Color.Black);
            Text.maxLines(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            TextArea.create({
                placeholder: { "id": 16777222, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" },
                text: 's_sJKAbPJB9u3bWLak1IVMzVjlusmUzziCxdGB+yr+CoqSo5tHi6KD0a/LNMEibNiDEaObXkeIX8layAzCApgZvvCZKaFxkz7vkIRG/wxfghP1Q9K7ai4n86I7nVlEhEdf9QovCHAO5Ax717IwYaijgHeW/YXGqbk6cdZglE+xVSoyoSCJokIqlajugj7luqR9lZtaPO6Tvz9eZAWqrR4I+CuunQEgsH+oRvEjkBDxxoj4SwBX4YsT1jKJQtBGTgh8KORxuJV2dbM0TwcoXg2x5oZEgYqVmWPP3WfsFd65oU/pGgTD7it70LPhaQkPVU1Ofxcm0KcGRAYac4CR6MsZF7ScuOWUHDk2vJ8rJTQ37y2jKq0Z5Cpo54XIyxX48lJbKvXHDZoJelGDhM4Ol6BUoKLtuyZDQvDFI6DzYCM3tjEjxYZF8b5qFmqTjZbdexZEmVirGoTRySuLzlK4KCarDtl6kv8SVOoJxZWmaRjZXk4H0+haeHLfew3pTNubVmelmNZeCcAx0qbziyWDXukjK/9Kc1tagy1jQ2L0ysDuosL3mJOaoq5MoftmXKhWm1qdmYQG1eu8Q8BW2rd+Wi/LdCcBXomGKvHRDfV4IVs89DL3v3SF6zxi1uEW8ie4PkNqxhqUYhXUFEehHt3Clfe5u+tEEoEEndGb40W2R/sCS9MahqGfcjgTSjgLoR9GcYFCujdi9fvrFazBYmqLu3aRTq78TUEZa5UhSVu/Iqc7uwfbnoL9P1tBvpKnDjQBkoOt'
            });
            TextArea.onChange((value: string) => {
                this.license = value;
            });
            TextArea.width('100%');
            TextArea.height({ "id": 16777242, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            TextArea.fontColor(Color.Black);
            TextArea.placeholderColor({ "id": 16777236, "type": 10001, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
        }, TextArea);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel({ "id": 16777223, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, { type: ButtonType.Capsule });
            Button.width('90%');
            Button.height({ "id": 16777266, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Button.margin({ top: { "id": 16777265, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, bottom: { "id": 16777267, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" } });
            Button.onClick(() => {
                if (this.licenseKey == null || this.licenseKey.length == 0) {
                    promptAction.showToast({
                        message: "请输入licenseKey",
                        duration: 5000,
                        bottom: '50%'
                    });
                    return;
                }
                if (this.license == null || this.license.length == 0) {
                    promptAction.showToast({
                        message: "请输入license",
                        duration: 5000,
                        bottom: '50%'
                    });
                    return;
                }
                EsignSDK.getInstance().initSDK(this.licenseKey, this.license, (result: InitResponse) => {
                    if (result.success) {
                        promptAction.showToast({
                            message: "初始化成功",
                            duration: 5000,
                            bottom: '50%'
                        });
                    }
                    else {
                        promptAction.showToast({
                            message: "初始化失败：" + result.code + " " + result.msg,
                            duration: 5000,
                            bottom: '50%'
                        });
                    }
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create({ "id": 16777221, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.width('100%');
            Text.height({ "id": 16777270, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Text.fontColor(Color.Black);
            Text.maxLines(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            TextInput.create({ placeholder: { "id": 16777221, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, text: '5442ff37ca8241fd9ecc4ff33540a323' });
            TextInput.onChange((value: string) => {
                this.faceCode = value;
            });
            __TextInput__inputStyle();
        }, TextInput);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel({ "id": 16777229, "type": 10003, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, { type: ButtonType.Capsule });
            Button.width('90%');
            Button.height({ "id": 16777266, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" });
            Button.margin({ top: { "id": 16777265, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" }, bottom: { "id": 16777267, "type": 10002, params: [], "bundleName": "com.esign.sdk", "moduleName": "entry" } });
            Button.onClick(() => {
                console.log(this.faceCode);
                let context = getContext(this) as common.UIAbilityContext;
                if (this.faceCode == null || this.faceCode.length == 0) {
                    promptAction.showToast({
                        message: "请输入faceAuthCode",
                        duration: 5000,
                        bottom: '50%'
                    });
                    return;
                }
                EsignSDK.getInstance().verity(this.faceCode, (result: FaceResultResponse) => {
                    console.error(JSON.stringify(result));
                    if (result.passed) {
                        promptAction.showToast({
                            message: "刷脸已经通过",
                            duration: 5000,
                            bottom: '50%'
                        });
                    }
                    else {
                        promptAction.showToast({
                            message: "刷脸失败 errCode:" + result.errCode + " msg:" + result.msg,
                            duration: 5000,
                            bottom: '50%'
                        });
                    }
                });
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "DemoPage";
    }
}
registerNamedRoute(() => new DemoPage(undefined, {}), "", { bundleName: "com.esign.sdk", moduleName: "entry", pagePath: "pages/DemoPage", pageFullPath: "entry/src/main/ets/pages/DemoPage", integratedHsp: "false", moduleType: "followWithHap" });
