import { FaceResultResponse } from "@normalized:N&&&esignfacesdk/src/main/ets/EsignSDK&1.0.0";
export interface LocalData {
    appDate: AppDate;
    pituLicense: string;
}
export interface AppDate {
    bundleId: string;
    feature: string;
    platform: string;
    production: string;
    type: string;
    url: string;
}
export class ValidateParam {
    public pituLicense: string = '';
    public bundleId: string = '';
    public platform: string = '';
    public timestamp: string = '';
    public deviceId: string = '';
    public signature: string = '';
    public sdkVersion: string = '';
}
export interface ValidateResponse {
    success: boolean;
    message: string;
    data: string;
}
export interface CheckResult {
    status: number;
    expiredTime: number;
    licenseId: string;
    signature: string;
    appSdkLicenseInfo: string;
}
export interface AppSdkLicenseInfo {
    inlayAppSdkLicenseList: Array<AppSdkLicense>;
    urlDomain: string;
}
export interface AppSdkLicense {
    sdkChannel: string;
    appSdkLicense: string;
    wbAppId: string;
    harmonyOsLicense: string;
}
export interface WakeUpResponse {
    success: boolean;
    message: string;
    data: WakeUpData;
}
export interface WakeUpData {
    faceAuthMode: string;
    downgrade: boolean;
    identityUrl: string;
    identityName: string;
    ticket: string;
    config: Config;
    faceContext: FaceContext;
}
export interface Config {
    resultH5Url: string;
}
export interface FaceContext {
    userId: string;
    orderNo: string;
    nonce: string;
    faceId: string;
    version: string;
}
export class WakeUpFaceRequest {
    faceAuthCode: string = '';
    faceAuthMode: string = 'APP_FACE_SDK';
    queryContext: QueryContext = new QueryContext();
    clientType: string = 'Harmony';
}
export class QueryContext {
    esignAppSdkVersion: string = 'esign-1.0.0';
    clientType: string = 'Harmony';
}
export class FaceResultRequest {
    faceAuthCode: string = '';
    faceAuthMode: string = "APP_FACE_SDK";
    extendedMap: Map<String, String> = new Map();
    clientType: String = "Harmony";
}
export class FaceResultQueryResponse {
    code: string = '';
    message: string = '';
    data: FaceResultResponse = new FaceResultResponse();
}
