import rcp from "@hms:collaboration.rcp";
import type { BusinessError } from "@ohos:base";
import type { FaceResultRequest, ValidateParam, WakeUpFaceRequest } from './DataModel';
export class Esign {
    constructor() {
    }
    validateData(url: string, param: ValidateParam): Promise<rcp.Response> {
        // 定义请求头
        let headers: rcp.RequestHeaders = {
            'X-Tsign-Service-Group': '',
            'content-Type': 'application/json'
        };
        const session = rcp.createSession();
        let req = new rcp.Request(url, 'POST', headers, param);
        return session.fetch(req)
            .then((response) => {
            console.error(JSON.stringify(response.headers));
            console.info(`validateData Response succeeded: ${response}`);
            return response;
        })
            .catch((err: BusinessError) => {
            console.error(`validateData Response err: Code is ${err.code}, message is ${JSON.stringify(err)}`);
            return Promise.reject(err);
        })
            .finally(() => {
            session.close(); // 无论发生什么，都要关闭会话
        });
    }
    verity(url: string, param: WakeUpFaceRequest): Promise<rcp.Response> {
        // 定义请求头
        let headers: rcp.RequestHeaders = {
            'X-Tsign-Service-Group': ''
        };
        const session = rcp.createSession();
        let req = new rcp.Request(url, 'POST', headers, param);
        return session.fetch(req)
            .then((response) => {
            console.error(JSON.stringify(response.headers));
            console.info(`verity Response succeeded: ${response}`);
            return response;
        })
            .catch((err: BusinessError) => {
            console.error(`verity Response err: Code is ${err.code}, message is ${JSON.stringify(err)}`);
            return Promise.reject(err);
        })
            .finally(() => {
            session.close(); // 无论发生什么，都要关闭会话
        });
    }
    queryFaceResult(url: string, para: FaceResultRequest): Promise<rcp.Response> {
        // 定义请求头
        let headers: rcp.RequestHeaders = {
            'X-Tsign-Service-Group': ''
        };
        const session = rcp.createSession();
        let req = new rcp.Request(url, 'POST', headers, para);
        return session.fetch(req)
            .then((response) => {
            console.error(JSON.stringify(response.headers));
            console.info(`queryFaceResult Response succeeded: ${response}`);
            return response;
        })
            .catch((err: BusinessError) => {
            console.error(`queryFaceResult Response err: Code is ${err.code}, message is ${JSON.stringify(err)}`);
            return Promise.reject(err);
        })
            .finally(() => {
            session.close(); // 无论发生什么，都要关闭会话
        });
    }
}
