export var DropReason;
(function (n4) {
    n4["Unknown"] = "-1";
    n4["DbCountLimitExceeded"] = "30001";
    n4["RecordSizeLimitExceeded"] = "30004";
    n4["DbInsertFail"] = "30005";
})(DropReason || (DropReason = {}));
export function getDropReasonDescription(reason) {
    switch (reason) {
        case DropReason.Unknown: return "unknown";
        case DropReason.DbCountLimitExceeded: return "dbsize-limit";
        case DropReason.RecordSizeLimitExceeded: return "datasize-limit";
        case DropReason.DbInsertFail: return "insertdb-fail";
        default: return "unknown";
    }
}
