import { DataType, TrackModelAbstractClass } from "@normalized:N&&&analytics/src/main/ets/c/x&2.3.1";
export var EventType;
(function (EventType) {
    EventType["Launch"] = "wa_lanch";
    EventType["Expo"] = "wa_expo";
    EventType["PageChg"] = "wa_pagechg";
    EventType["Background"] = "wa_bckgd";
    EventType["Foreground"] = "wa_forgd";
    EventType["Custom"] = "wa_cust";
})(EventType || (EventType = {}));
export default class Event extends TrackModelAbstractClass {
    constructor(event_name, event_value, event_info, event_type = EventType.Custom, data_type = DataType.Event) {
        super();
        this.time_stamp = Date.now();
        this.event_name = event_name;
        this.event_value = event_value;
        this.event_info = event_info;
        this.event_type = event_type;
        this.data_type = data_type;
    }
    getProp(key) {
        return this.props[key] ?? null;
    }
    toRecord() {
        const record = {};
        record.time_stamp = this.time_stamp;
        record.data_type = this.data_type;
        if (this.trace_id) {
            record.trace_id = this.trace_id;
        }
        if (this.growth_id) {
            record.growth_id = this.growth_id;
        }
        record.event_name = this.event_name;
        record.event_type = this.event_type;
        if (this.event_value) {
            record.event_value = this.event_value;
        }
        if (this.event_time) {
            record.event_time = this.event_time;
        }
        const keys = Object.keys(this.props);
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            const value = this.props[key];
            if (value !== null) {
                record[key] = value;
            }
        }
        if (this.event_info) {
            record.event_info = this.event_info;
        }
        return record;
    }
}
