export var DataType;
(function (DataType) {
    DataType["Event"] = "event";
    DataType["Error"] = "err";
    DataType["Log"] = "log";
})(DataType || (DataType = {}));
export class TrackModelAbstractClass {
    constructor() {
        this.time_stamp = Date.now();
        this.props = {};
    }
    setProp(key, value) {
        this.props[key] = value;
    }
    setProps(values) {
        const keys = Object.keys(values);
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            const value = values[key];
            this.setProp(key, value);
        }
    }
    toString() {
        return `trace_id: ${this.trace_id}, growth_id: ${this.growth_id}, data_type: ${this.data_type}`;
    }
}
