import { CameraStatus } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/BaseCamera&1.2.1'; import HashSet from '@ohos:util.HashSet'; import { CameraInfoDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraInfo&1.2.1'; import { CameraDeviceCallback, DeviceState, } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraDeviceCallback&1.2.1'; import { WeCameraInput } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/WeCameraInput&1.2.1'; import { printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import { CameraX } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraX&1.2.1'; import display from "@ohos:display"; import { Scene } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import { VideoSessionFactory } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/SessionFactory&1.2.1'; import hilog from '@ohos:hilog'; export class Camera { constructor(h2, i2) { this.mode = Scene.PHOTO; this.useCaseList = new HashSet(); this.preFoldStatus = display.getFoldStatus(); this.foldStatusChangeListener = async (k2) => { hilog.debug(0x0000, "CameraX", `Camera foldStatusListener: status: ${k2.toString()}`); if (this.preFoldStatus == k2) { return; } if ((k2 == display.FoldStatus.FOLD_STATUS_FOLDED && this.preFoldStatus == display.FoldStatus.FOLD_STATUS_HALF_FOLDED) || (this.preFoldStatus == display.FoldStatus.FOLD_STATUS_FOLDED && k2 == display.FoldStatus.FOLD_STATUS_HALF_FOLDED)) { await this.close().catch(); await this.release().catch(); if (this.callback !== undefined) { hilog.debug(0x0000, "CameraX", "Camera updateCameraStatus: camera has been closed by system, Notify listener"); this.callback(this.cameraDetail.getCameraId()); } this.callback == undefined; } this.preFoldStatus = k2; }; this.sysCamera = i2; this.stateCallback = new CameraDeviceCallback(this); this.sysCameraManager = h2; this.sessionFactory = CameraX.getSessionFactory(); this.cameraDetail = new CameraInfoDetail(i2, h2); hilog.debug(0x0000, "CameraX", `Camera constructor: ${i2.cameraId}`); this.listenFoldStatusChange(); } listenFoldStatusChange() { display.on('foldStatusChange', this.foldStatusChangeListener); } addSysInterruptListener(g2) { this.callback = g2; } onAbilityForeground() { hilog.debug(0x0000, "CameraX", "Camera onAbilityForeground"); if (!this.cameraDetail.getAvailable()) { if (this.stateCallback.getState() !== DeviceState.RELEASED) { this.release().catch(); } if (this.callback !== undefined) { hilog.debug(0x0000, "CameraX", "Camera updateCameraStatus: camera has been closed by system, Notify listener"); this.callback(this.cameraDetail.getCameraId()); } } } onWindowStageActive() { hilog.debug(0x0000, "CameraX", "Camera onWindowStageActive"); } async onWindowStageInactive() { hilog.debug(0x0000, "CameraX", "Camera onWindowStageInactive"); } updateCameraStatus(f2) { if (f2 == CameraStatus.AVAILABLE) { this.cameraDetail.updateCameraStatus(false); } if (f2 == CameraStatus.UNAVAILABLE) { this.cameraDetail.updateCameraStatus(true); } } async open(d2 = Scene.VIDEO, e2 = false) { hilog.debug(0x0000, "CameraX", "Camera open"); if (this.stateCallback.getState() == DeviceState.UNINITIALIZED) { if (d2 !== undefined) { this.mode = d2; } if (this.mode == Scene.VIDEO) { this.sessionFactory = new VideoSessionFactory(this.sysCameraManager); } else { this.sessionFactory = CameraX.getSessionFactory(); } this.initialize(); } if (this.stateCallback.getState() == DeviceState.OPENING || this.stateCallback.getState() == DeviceState.REOPENING || this.stateCallback.getState() == DeviceState.OPENED) { return; } await this.openCameraDevice(); } initialize() { try { hilog.debug(0x0000, "CameraX", "Camera initialize"); this.cameraInput = new WeCameraInput(this.sysCameraManager, this.sysCamera); this.session = this.sessionFactory.getSession(this.cameraDetail); this.stateCallback.setState(DeviceState.INITIALIZED); } catch (c2) { this.stateCallback.setState(DeviceState.UNINITIALIZED); printErrorDetail(c2); } } async openCameraDevice() { hilog.debug(0x0000, "CameraX", "Camera openCameraDevice"); this.stateCallback.setState(this.stateCallback.getState() == DeviceState.INITIALIZED ? DeviceState.OPENING : DeviceState.REOPENING); await this.cameraInput?.open().then(async () => { CameraX.getCameraManager().onCameraActive(this); if (this.cameraInput == undefined) { return; } await this.session?.addOnlineSourceCase(this.cameraInput) .then(() => this.stateCallback.setState(DeviceState.OPENED)) .catch((b2) => printErrorDetail(b2, "Camera", "this.session?.addOnlineSourceCase fail")); }).catch((y1) => { printErrorDetail(y1, "Camera", "openCameraDevice fail"); this.stateCallback.setState(DeviceState.INITIALIZED); }); } async close() { try { this.stateCallback.setState(DeviceState.CLOSING); await this.session?.stop().catch(); await this.cameraInput?.close().catch(); this.stateCallback.setState(DeviceState.CLOSED); } catch (v1) { printErrorDetail(v1); this.initialize(); } } async release() { CameraX.getCameraManager().onCameraInactive(this); await this._release().catch(); display.off('foldStatusChange', this.foldStatusChangeListener); } async _release() { try { if (this.stateCallback.getState() == DeviceState.OPENED) { this.stateCallback.setState(DeviceState.CLOSING); await this.cameraInput?.close().catch(); this.stateCallback.setState(DeviceState.CLOSED); } if (this.stateCallback.getState() == DeviceState.CLOSED) { this.stateCallback.setState(DeviceState.RELEASING); await this.session?.release().catch(); } this.cameraInput = undefined; } catch (u1) { printErrorDetail(u1); } finally { this.stateCallback.setState(DeviceState.RELEASED); } } async addOnlineUseCaseList(m1) { hilog.debug(0x0000, "CameraX", `Camera addOnlineUseCaseList current state: ${DeviceState[this.stateCallback.getState()]}`); if (this.stateCallback.getState().valueOf() < DeviceState.OPENING.valueOf()) { await this.open(); } if (this.session == undefined) { throw new CameraErrorImpl("Camera", "Session is undefined, call open function firstly"); } if (this.stateCallback.getState().valueOf() < DeviceState.OPENED.valueOf()) { throw new CameraErrorImpl("Camera", "cant add online UseCase, call open function firstly"); } m1.forEach((t1) => this.useCaseList.add(t1)); return await this.session.addOnlineUseCases(m1).then((p1) => { let q1 = this.stateCallback.getState().valueOf(); if (p1 && q1 >= DeviceState.OPENED.valueOf()) { this.stateCallback.setState(DeviceState.STARTING); hilog.debug(0x0000, "CameraX", `Camera addOnlineUseCaseList session start`); setTimeout(() => { this.session?.start().then(() => this.stateCallback.setState(DeviceState.STARTED)) .catch(printErrorDetail); }, 100); } if (this.session == undefined) { throw new CameraErrorImpl("Camera", "addOnlineUseCase session is null"); } return this.session; }); } async addOnlineUseCase(h1) { if (this.stateCallback.getState().valueOf() < DeviceState.OPENING.valueOf()) { await this.open(); } if (this.session == undefined) { throw new CameraErrorImpl("Camera", "Session is undefined, call open function firstly"); } if (this.stateCallback.getState().valueOf() < DeviceState.OPENED.valueOf()) { throw new CameraErrorImpl("Camera", "cant add online UseCase, call open function firstly"); } this.useCaseList.add(h1); return await this.session.addOnlineUseCase(h1).then((j1) => { let k1 = this.stateCallback.getState().valueOf(); if (j1 && k1 >= DeviceState.OPENED.valueOf()) { this.stateCallback.setState(DeviceState.STARTING); hilog.debug(0x0000, "CameraX", `Camera addOnlineUseCase session start`); this.session?.start().then(() => this.stateCallback.setState(DeviceState.STARTED)) .catch(printErrorDetail); } if (this.session == undefined) { throw new CameraErrorImpl("Camera", "addOnlineUseCase session is null"); } return this.session; }); } async removeOnlineUseCase(g1) { if (this.session !== undefined) { return this.session.removeOnlineUseCase(g1); } return false; } getCameraInfo() { return this.cameraDetail; } onUseCaseActive(f1) { throw new Error('Method not implemented.'); } onUseCaseInactive(e1) { throw new Error('Method not implemented.'); } onUseCaseUpdated(d1) { throw new Error('Method not implemented.'); } onUseCaseReset(c1) { throw new Error('Method not implemented.'); } } 