import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import { CameraPosition } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import { DefaultCameraFactory } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraFactory&1.2.1'; import { DefaultCameraProvider } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraProvider&1.2.1'; import { CameraRepository } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraRepository&1.2.1'; import { AppLifecycleManager } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/AppLifecycleManager&1.2.1'; import { DefaultSessionFactory } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/SessionFactory&1.2.1'; import display from "@ohos:display"; import { printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import hilog from '@ohos:hilog'; import deviceInfo from "@ohos:deviceInfo"; let apiVersion = deviceInfo.sdkApiVersion; export class CameraX { constructor() { this.initialized = false; this.cameraRepository = new CameraRepository(); this.cameraProvider = new DefaultCameraProvider(this.cameraRepository); this.appLifecycleManager = new AppLifecycleManager(); } static getInstance() { if (CameraX.INSTANCE == undefined) { CameraX.INSTANCE = new CameraX(); } return CameraX.INSTANCE; } static isInitialized() { if (CameraX.INSTANCE == undefined) { return false; } return CameraX.INSTANCE.initialized; } static init(w7) { if (!CameraX.isInitialized()) { CameraX.getInstance().initialize(w7.getApplicationContext()); } } static getCameraFactory() { if (!CameraX.isInitialized()) { throw new CameraErrorImpl("CameraX", "getCameraFactory fail: call init function firstly"); } let v7 = CameraX.getInstance()?.cameraFactory; if (v7 == undefined) { throw new CameraErrorImpl("CameraX", "getCameraFactory fail: INSTANCE cameraFactory cant be null"); } return v7; } static getSessionFactory() { if (!CameraX.isInitialized()) { throw new CameraErrorImpl("CameraX", "getSessionFactory fail: call init function firstly"); } let u7 = CameraX.getInstance()?.sessionFactory; if (u7 == undefined) { throw new CameraErrorImpl("CameraX", "getSessionFactory fail: INSTANCE cameraFactory cant be null"); } return u7; } static isAppStateActive() { return CameraX.getInstance().appLifecycleManager.isAppActive(); } static getCameraManager() { if (!CameraX.isInitialized()) { throw new CameraErrorImpl("CameraX", "getCameraManager fail: call init function firstly"); } return CameraX.getInstance().cameraRepository; } initialize(s7) { if (this.initialized) { return; } this.context = s7.getApplicationContext(); hilog.debug(0x0000, "CameraX", "CameraX initializing! Current Api: " + apiVersion); try { this.cameraFactory = new DefaultCameraFactory(s7.getApplicationContext()); this.sessionFactory = new DefaultSessionFactory(s7.getApplicationContext()); this.initialized = true; if (this.cameraFactory !== undefined) { this.cameraRepository.init(this.cameraFactory, s7.getApplicationContext()); } this.callbackId = s7.getApplicationContext().on("abilityLifecycle", this.appLifecycleManager); this.appLifecycleManager.addObserver(this.cameraRepository); hilog.debug(0x0000, "CameraX", "CameraX initialized"); this.initialized = true; } catch (t7) { printErrorDetail(t7); } } static dispose() { if (!CameraX.isInitialized()) { return; } hilog.debug(0x0000, "CameraX", "CameraX disposing!"); CameraX.getInstance().appLifecycleManager.removeObserver(CameraX.getInstance().cameraRepository); CameraX.getInstance().cameraRepository.dispose(); const q7 = CameraX.getInstance().callbackId; if (q7 != undefined) { const r7 = CameraX.getInstance().context; if (r7 != undefined) { r7.getApplicationContext().off("abilityLifecycle", q7); } } CameraX.INSTANCE = undefined; hilog.debug(0x0000, "CameraX", "CameraX disposed!"); } static getBackendCamera() { let p7 = CameraX.getInstance().cameraProvider; if (p7 == undefined) { throw new CameraErrorImpl("Init CameraX lib firstly!"); } return p7.getCamera(CameraPosition.BACKEND); } static getFrontCamera() { if (display.isFoldable() && display.getFoldStatus() == display.FoldStatus.FOLD_STATUS_EXPANDED) { try { let o7 = CameraX.getFrontInnerCamera(); if (o7 != undefined) { return o7; } } catch (n7) { printErrorDetail(n7); } } hilog.debug(0x0000, "CameraX", "Camera fold font"); let m7 = CameraX.getInstance().cameraProvider; if (m7 == undefined) { throw new CameraErrorImpl("Init CameraX lib firstly!"); } return m7.getCamera(CameraPosition.FRONT); } static getFrontInnerCamera() { hilog.debug(0x0000, "CameraX", "Camera fold inner "); let l7 = CameraX.getInstance().cameraProvider; if (l7 == undefined) { throw new CameraErrorImpl("Init CameraX lib firstly!"); } return l7.getCamera(CameraPosition.FOLD_INNER); } } 