import { ExposureMode, Scene } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import HashSet from "@ohos:util.HashSet"; import camera from "@ohos:multimedia.camera"; import { printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import { PreviewOutputFactory } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/SysOutputFactory&1.2.1'; import { DefaultPreviewProfileSelector } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraProfileSelector&1.2.1'; import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import hilog from '@ohos:hilog'; export var SessionState; (function (j10) { j10[j10["INIT"] = 0] = "INIT"; j10[j10["BEGIN"] = 1] = "BEGIN"; j10[j10["CONFIGED"] = 2] = "CONFIGED"; j10[j10["STARTING"] = 3] = "STARTING"; j10[j10["STARTED"] = 4] = "STARTED"; j10[j10["STOPING"] = 5] = "STOPING"; j10[j10["STOPED"] = 6] = "STOPED"; j10[j10["RELEASING"] = 7] = "RELEASING"; j10[j10["RELEASED"] = 8] = "RELEASED"; })(SessionState || (SessionState = {})); export function getSupportedColorSpaces(f10) { let g10 = []; try { g10 = f10.getSupportedColorSpaces(); } catch (h10) { let i10 = h10; hilog.error(0x0000, "CameraX", "The getSupportedColorSpaces call failed. error code: {}", i10.code); } return g10; } export class PhotoSession { constructor(b10, c10) { this.useCaseList = new HashSet(); this.profileSelector = new DefaultPreviewProfileSelector(); this.sessionState = SessionState.INIT; this.onError = (e10) => { printErrorDetail(e10, "PhotoSession", "onError"); }; this.cameraInfo = c10; this.manager = b10; this.outputFactory = PreviewOutputFactory.createDefaultPreviewOutputFactory(b10); this.sysSession = b10.createSession(camera.SceneMode.NORMAL_PHOTO); this.sysSession.on("error", this.onError); } async removeOnlineSourceCase(z9) { hilog.debug(0x0000, "CameraX", "Session removeOnlineSourceCase"); try { this.sysSession.beginConfig(); } catch (a10) { printErrorDetail(a10); } this.sysSession.removeInput(z9.getSystemCameraInput()); return true; } async addOnlineSourceCase(v9) { hilog.debug(0x0000, "CameraX", "Session addOnlineSourceCase"); if (this.sessionState == SessionState.STARTED) { await this.stop().catch((y9) => { printErrorDetail(y9); return false; }); } try { this.sysSession.beginConfig(); this.sessionState = SessionState.BEGIN; } catch (w9) { printErrorDetail(w9); return false; } if (this.sysSession.canAddInput(v9.getSystemCameraInput())) { this.sysSession.addInput(v9.getSystemCameraInput()); hilog.debug(0x0000, "CameraX", "Session addOnlineSourceCase success"); return true; } return false; } onFocusStateChange(u9) { } onZoomInfoAvailable(t9) { } async addOnlineUseCases(e9) { hilog.debug(0x0000, "CameraX", "PhotoSession addOnlineUseCaseList"); if (e9.length == 0) { return false; } let f9; await this.stop().catch((s9) => { printErrorDetail(s9, "addOnlineUseCase stop session"); f9 = s9; }); try { this.sysSession.beginConfig(); } catch (r9) { printErrorDetail(r9); return false; } e9.forEach((m9) => { let n9 = { targetSize: m9.size, format: m9.format, }; let o9 = m9.getOutputFactory(this.manager); if (o9 == undefined) { o9 = this.outputFactory; } let p9 = o9.getSysOutput(m9.target, n9, Scene.PHOTO, this.cameraInfo); if (this.sysSession.canAddOutput(p9.output)) { try { this.sysSession.addOutput(p9.output); } catch (q9) { printErrorDetail(q9); } hilog.debug(0x0000, "CameraX", "PhotoSession addOnlineUseCase success"); } }); let g9 = await this.sysSession.commitConfig().then(() => true).catch((l9) => printErrorDetail(l9, "PhotoSession", "addOnlineUseCase commitConfig fail")); if (g9 == true && f9 == null) { await this.start(); } return g9 == true; } async addOnlineUseCase(s8) { hilog.debug(0x0000, "CameraX", "Session addOnlineUseCase"); this.useCaseList.add(s8); let t8; await this.stop().catch((d9) => { printErrorDetail(d9, "addOnlineUseCase stop session"); t8 = d9; }); let u8 = { targetSize: s8.size, format: s8.format, }; let v8 = s8.getOutputFactory(this.manager); if (v8 == undefined) { v8 = this.outputFactory; } let w8 = v8.getSysOutput(s8.target, u8, Scene.PHOTO, this.cameraInfo); try { this.sysSession.beginConfig(); } catch (c9) { printErrorDetail(c9); } if (this.sysSession.canAddOutput(w8.output)) { this.sysSession.addOutput(w8.output); hilog.debug(0x0000, "CameraX", "Session addOnlineUseCase success"); let y8 = await this.sysSession.commitConfig().then(() => { if (t8 == undefined) { this.sysSession.start(); } return true; }).catch((b9) => printErrorDetail(b9, "PhotoSession", "addOnlineUseCase commitConfig fail")); return y8 == true; } return false; } async removeOnlineUseCase(r8) { this.useCaseList.remove(r8); return true; } async start() { if (this.sessionState == SessionState.CONFIGED) { throw new CameraErrorImpl("IllegelStateError", "Session start", 217); } this.sessionState == SessionState.STARTING; await this.sysSession.start(); this.sessionState == SessionState.STARTED; } async stop() { if (this.sessionState == SessionState.STARTED) { throw new CameraErrorImpl("SessionIllegelStateError", "Session stop", 226); } this.sessionState == SessionState.STOPING; await this.sysSession.stop().catch((q8) => printErrorDetail(q8)); this.sessionState == SessionState.STOPED; } async release() { this.sessionState == SessionState.RELEASING; await this.sysSession.release().catch(); this.sysSession.off("error", this.onError); this.sessionState == SessionState.RELEASED; } isFocusModeSupported(o8) { return this.sysSession.isFlashModeSupported(o8.valueOf()); } getFocusMode() { return this.sysSession.getFocusMode().valueOf(); } setFocusMode(n8) { this.sysSession.setFocusMode(n8.valueOf()); } setFocusPoint(m8) { this.sysSession.setFocusPoint(m8); } getFocusPoint() { return this.sysSession.getFocusPoint(); } getFocalLength() { return this.sysSession.getFocalLength(); } hasFlash() { return this.hasFlash(); } isFlashModeSupported(l8) { return this.sysSession.isFlashModeSupported(l8.valueOf()); } getFlashMode() { return this.sysSession.getFocusMode().valueOf(); } setFlashMode(k8) { return this.sysSession.setFlashMode(k8.valueOf()); } isExposureModeSupported(j8 = ExposureMode.AUTO) { return this.sysSession.isExposureModeSupported(camera.ExposureMode.EXPOSURE_MODE_AUTO); } getExposureMode() { return ExposureMode.AUTO; } setExposureMode(i8) { throw new Error('Method not implemented.'); } getMeteringPoint() { throw new Error('Method not implemented.'); } setMeteringPoint(h8) { throw new Error('Method not implemented.'); } getExposureBiasRange() { return this.sysSession.getExposureBiasRange(); } setExposureBias(g8) { this.sysSession.setExposureBias(g8); } getExposureValue() { return this.sysSession.getExposureValue(); } getZoomRatioRange() { throw new Error('Method not implemented.'); } getZoomRatio() { throw new Error('Method not implemented.'); } setZoomRatio(f8) { throw new Error('Method not implemented.'); } setSmoothZoom(d8, e8) { throw new Error('Method not implemented.'); } onUseCaseActive(c8) { this.useCaseList.add(c8); } onUseCaseInactive(b8) { this.useCaseList.remove(b8); } onUseCaseUpdated(a8) { throw new Error('Method not implemented.'); } onUseCaseReset(z7) { throw new Error('Method not implemented.'); } } 