import camera from "@ohos:multimedia.camera"; import { PreviewProfileSelector, VideoProfileSelector } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Selector&1.2.1'; import { WeCameraConfigBuilder } from '@normalized:N&&&harmonyCameraLib/src/main/ets/WeCameraConfig&1.2.1'; import { printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import { CameraPosition, Scene } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import { CameraStatus } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/BaseCamera&1.2.1'; import { CameraX } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraX&1.2.1'; import hilog from '@ohos:hilog'; export class WeCameraDevice { constructor(x17, y17) { this.available = true; this.onSysCameraInputError = async (a18) => { printErrorDetail(a18); CameraX.getCameraManager().onCameraInactive(this); await this.release(); }; this.sysCamera = y17; this.sysCameraManager = x17; this.supportModeArray = x17.getSupportedSceneModes(this.sysCamera); this.previewSelector = new PreviewProfileSelector(); } addOnlineUseCaseList(w17) { throw new Error('Method not implemented.'); } getSupportModes() { throw new Error('Method not implemented.'); } getSupportPreviewProfiles(v17) { throw new Error('Method not implemented.'); } getSupportPhotoProfiles(u17) { throw new Error('Method not implemented.'); } getSupportVideoProfiles(t17) { throw new Error('Method not implemented.'); } addSysInterruptListener(s17) { this.callback = s17; } onAbilityForeground() { if (!this.available) { this.release().catch(); if (this.callback !== undefined) { hilog.debug(0x0000, "CameraX", "Camera updateCameraStatus: camera has been closed by system, Notify listener"); this.callback(this.sysCamera.cameraId); } } } onWindowStageActive() { } onWindowStageInactive() { } updateCameraStatus(r17) { if (r17 == CameraStatus.AVAILABLE) { hilog.debug(0x0000, "CameraX", "Camera updateCameraStatus: camera unavailable"); this.available = false; } } getCameraPosition() { if (this.sysCamera.cameraPosition == camera.CameraPosition.CAMERA_POSITION_BACK) { return CameraPosition.BACKEND; } return CameraPosition.FRONT; } getCameraId() { return this.sysCamera.cameraId; } getAvailable() { return this.available; } async open(n17 = Scene.PHOTO) { if (this.input == undefined) { this.input = this.getSysCameraInput(); this.input?.on("error", this.sysCamera, this.onSysCameraInputError); } await this.input.open().then(() => { hilog.debug(0x0000, "CameraX", "WeCameraDevice onCameraActive"); CameraX.getCameraManager().onCameraActive(this); }).catch((q17) => printErrorDetail(q17)); } async stop() { await this.input?.close(); } async release() { await this.stop(); CameraX.getCameraManager().onCameraInactive(this); this.input?.off("error", this.sysCamera, this.onSysCameraInputError); this.input = undefined; } addOnlineUseCase(m17) { throw new Error('Method not implemented.'); } removeOnlineUseCase(l17) { throw new Error('Method not implemented.'); } getCameraInfo() { return this; } onUseCaseActive(k17) { throw new Error('Method not implemented.'); } onUseCaseInactive(j17) { throw new Error('Method not implemented.'); } onUseCaseUpdated(i17) { throw new Error('Method not implemented.'); } onUseCaseReset(h17) { throw new Error('Method not implemented.'); } async getPreviewOutput(y16, z16) { let a17 = this.sysCameraManager.getSupportedOutputCapability(this.sysCamera, z16); let b17 = a17.previewProfiles; try { let d17 = new WeCameraConfigBuilder() .previewSurfaceSize(y16.outputSize); let e17 = d17.build(); let f17 = this.previewSelector.select(b17, e17); let g17 = this.sysCameraManager.createPreviewOutput(f17, y16.surfaceId); return g17; } catch (c17) { printErrorDetail(c17); } return undefined; } async getVideoOutput(p16, q16) { let r16 = this.sysCameraManager.getSupportedOutputCapability(this.sysCamera, q16); let s16 = r16.videoProfiles; try { let u16 = new WeCameraConfigBuilder() .previewSurfaceSize(p16.outputSize); let v16 = u16.build(); let w16 = new VideoProfileSelector().select(s16, v16); let x16 = this.sysCameraManager.createVideoOutput(w16, p16.surfaceId); return x16; } catch (t16) { printErrorDetail(t16); } return undefined; } async getPhotoOutput(g16, h16) { let i16 = this.sysCameraManager.getSupportedOutputCapability(this.sysCamera, h16); let j16 = i16.videoProfiles; try { let l16 = new WeCameraConfigBuilder() .previewSurfaceSize(g16.outputSize); let m16 = l16.build(); let n16 = new VideoProfileSelector().select(j16, m16); let o16 = this.sysCameraManager.createPhotoOutput(n16); return o16; } catch (k16) { printErrorDetail(k16); } return undefined; } async onInputError(c16) { this.input?.on("error", this.sysCamera, async (e16) => { try { await c16(e16); } catch (f16) { printErrorDetail(f16); } printErrorDetail(e16); }); } isInvalid() { return this.input == undefined; } async close() { try { await this.input?.close(); } catch (b16) { printErrorDetail(b16); } finally { this.input = undefined; } } getSysCameraInput() { if (this.input !== undefined) { return this.input; } try { this.input = this.sysCameraManager.createCameraInput(this.sysCamera); return this.input; } catch (a16) { throw printErrorDetail(a16); } } } 