import hilog from "@ohos:hilog";
export class WBLogAdapter {
    constructor() {
        this._logListener = new LogsListener();
    }
    static getInstance() {
        if (!WBLogAdapter.instance) {
            WBLogAdapter.instance = new WBLogAdapter();
        }
        return WBLogAdapter.instance;
    }
    getLogsListener() {
        return this._logListener;
    }
    setLogsListener(s) {
        this._logListener = s;
    }
}
export class LogsListener {
    constructor() {
    }
    onLogs(o, p, q, r) {
        switch (o) {
            case LogLevel.DEBUG:
                hilog.debug(p, q, '%{public}s', r);
                break;
            case LogLevel.INFO:
                hilog.info(p, q, '%{public}s', r);
                break;
            case LogLevel.WARN:
                hilog.warn(p, q, '%{public}s', r);
                break;
            case LogLevel.ERROR:
                hilog.error(p, q, '%{public}s', r);
                break;
            case LogLevel.FATAL:
                hilog.fatal(p, q, '%{public}s', r);
                break;
            default: hilog.info(p, q, '%{public}s', r);
        }
    }
}
export var LogLevel;
(function (n) {
    n[n["DEBUG"] = 3] = "DEBUG";
    n[n["INFO"] = 4] = "INFO";
    n[n["WARN"] = 5] = "WARN";
    n[n["ERROR"] = 6] = "ERROR";
    n[n["FATAL"] = 7] = "FATAL";
})(LogLevel || (LogLevel = {}));
