import radio from "@ohos.telephony.radio";
import m from "../g/h";
import connection from "@ohos.net.connection";
import g6 from "../g/w";
export var h6;
(function (u6) {
    u6["NETWORK_TYPE_2G"] = "2g";
    u6["NETWORK_TYPE_3G"] = "3g";
    u6["NETWORK_TYPE_4G"] = "4g";
    u6["NETWORK_TYPE_5G"] = "5g";
    u6["NETWORK_TYPE_WIFI"] = "wifi";
    u6["NETWORK_TYPE_CELLULAR"] = "Cellular";
    u6["NETWORK_TYPE_ETHERNET"] = "Ethernet";
    u6["NETWORK_TYPE_VPN"] = "VPN";
    u6["NETWORK_TYPE_UNAVAILABLE"] = "unavailable";
    u6["NETWORK_TYPE_UNKNOWN"] = "unknown";
})(h6 || (h6 = {}));
export default class NetworkListener {
    constructor() {
        this.e3 = h6.NETWORK_TYPE_UNKNOWN;
        this.f3 = new g6();
        this.initialize();
    }
    initialize() {
        m.d("NetworkListener initialize");
        this.g3();
        this.h3();
    }
    h3() {
        let o6 = connection.createNetConnection();
        this.i3 = o6;
        o6.register((error) => {
            if (error === undefined) {
                m.d('register netCon success');
            }
            else {
                m.e('register netCon error ' + JSON.stringify(error));
            }
        });
        o6.on('netAvailable', (data) => {
            m.i("netAvailable data: " + JSON.stringify(data));
            this.g3();
        });
        o6.on('netUnavailable', () => {
            m.i("Succeeded to get unavailable net event");
            this.g3();
        });
        o6.on('netLost', (data) => {
            m.i("netLost data: " + JSON.stringify(data));
            this.g3();
        });
        o6.on('netCapabilitiesChange', (data) => {
            m.i("netCapabilitiesChange data: " + JSON.stringify(data));
            this.g3();
        });
    }
    g3() {
        try {
            const netHandle = connection.getDefaultNetSync();
            m.d("netId: " + netHandle.netId);
            if (netHandle.netId == 0) {
                m.d(`netId is 0`);
                this.f2 = h6.NETWORK_TYPE_UNAVAILABLE;
                return;
            }
            const netCapabilities = connection.getNetCapabilitiesSync(netHandle);
            m.d("netCapabilities data: " + JSON.stringify(netCapabilities));
            let n6 = netCapabilities.bearerTypes.pop();
            if (n6 == connection.NetBearType.BEARER_CELLULAR) {
                this.j3();
            }
            else if (n6 !== undefined) {
                this.f2 = this.l3(n6);
            }
            else {
                this.f2 = h6.NETWORK_TYPE_UNAVAILABLE;
            }
        }
        catch (err) {
            m.e(`Failed to update current network state: ${JSON.stringify(err)}`);
            this.f2 = h6.NETWORK_TYPE_UNAVAILABLE;
        }
    }
    async j3() {
        try {
            const slotId = await radio.getPrimarySlotId();
            m.d(`getPrimarySlotId success, slotId ${slotId}`);
            let l6 = radio.getSignalInformationSync(slotId);
            m.d(`signal ${slotId} information size is: ` + l6.length);
            l6.forEach((signalInformation) => {
                let networkType = this.m3(signalInformation.signalType);
                this.f2 = networkType;
                m.d(`signal ${slotId} networkType ` + networkType);
            });
        }
        catch (err) {
            m.e(`Failed to get cellular information: ${JSON.stringify(err)}`);
        }
    }
    m3(networkType) {
        switch (networkType) {
            case radio.NetworkType.NETWORK_TYPE_GSM:
            case radio.NetworkType.NETWORK_TYPE_CDMA: return h6.NETWORK_TYPE_2G;
            case radio.NetworkType.NETWORK_TYPE_WCDMA:
            case radio.NetworkType.NETWORK_TYPE_TDSCDMA: return h6.NETWORK_TYPE_3G;
            case radio.NetworkType.NETWORK_TYPE_LTE: return h6.NETWORK_TYPE_4G;
            case radio.NetworkType.NETWORK_TYPE_NR: return h6.NETWORK_TYPE_5G;
            default: return h6.NETWORK_TYPE_CELLULAR;
        }
    }
    l3(k6) {
        switch (k6) {
            case connection.NetBearType.BEARER_CELLULAR: return h6.NETWORK_TYPE_CELLULAR;
            case connection.NetBearType.BEARER_WIFI: return h6.NETWORK_TYPE_WIFI;
            case connection.NetBearType.BEARER_ETHERNET: return h6.NETWORK_TYPE_ETHERNET;
            case connection.NetBearType.BEARER_VPN: return h6.NETWORK_TYPE_VPN;
            default: return h6.NETWORK_TYPE_UNKNOWN;
        }
    }
    set f2(j6) {
        if (this.e3 !== j6) {
            this.e3 = j6;
            m.d(`currentNetworkState = ${j6}`);
            this.f3.emit('networkStateChanged', this.e3);
        }
    }
    get f2() {
        return this.e3;
    }
    c2() {
        return this.f2 != h6.NETWORK_TYPE_UNAVAILABLE
            && this.f2 != h6.NETWORK_TYPE_UNKNOWN;
    }
    d2() {
        return this.f2 == h6.NETWORK_TYPE_2G
            || this.f2 == h6.NETWORK_TYPE_3G
            || this.f2 == h6.NETWORK_TYPE_4G
            || this.f2 == h6.NETWORK_TYPE_5G
            || this.f2 == h6.NETWORK_TYPE_CELLULAR;
    }
    on(event, listener) {
        this.f3.on(event, listener);
    }
    off(event, listener) {
        this.f3.off(event, listener);
    }
}
