import { DataType, TrackModelAbstractClass } from "./x";
export default class ErrorModel extends TrackModelAbstractClass {
    constructor(err_type, err_path, err_line, err_col, err_stack) {
        super();
        this.data_type = DataType.Error;
        this.err_type = err_type;
        this.err_path = err_path;
        this.err_line = err_line;
        this.err_col = err_col;
        this.err_stack = err_stack;
    }
    toRecord() {
        const record = {};
        record.time_stamp = this.time_stamp;
        record.data_type = this.data_type;
        if (this.trace_id) {
            record.trace_id = this.trace_id;
        }
        if (this.growth_id) {
            record.growth_id = this.growth_id;
        }
        if (this.err_type) {
            record.err_type = this.err_type;
        }
        if (this.err_path) {
            record.err_path = this.err_path;
        }
        if (this.err_line) {
            record.err_line = this.err_line;
        }
        if (this.err_col) {
            record.err_col = this.err_col;
        }
        if (this.err_stack) {
            record.err_stack = this.err_stack;
        }
        const keys = Object.keys(this.props);
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            const value = this.props[key];
            if (value !== null) {
                record[key] = value;
            }
        }
        return record;
    }
}
