import Model from "./e";
import deviceInfo from '@ohos.deviceInfo';
import WaLog from "../g/h";
import display from '@ohos.display';
import dataPreferences from '@ohos.data.preferences';
import generateUUID from "../g/s";
import Intl from '@ohos.intl';
export default class DeviceInfo extends Model {
    constructor(context) {
        super();
        this.phone_name = deviceInfo.marketName;
        this.device_info = JSON.stringify({
            "harmonyVersion": deviceInfo.osFullName,
            "harmonyDisplayVersion": deviceInfo.displayVersion
        });
        this.metrics_device = deviceInfo.productModel;
        this.model = deviceInfo.brand;
        this.metrics_os = "Harmony";
        this.metrics_os_version = deviceInfo.sdkApiVersion.toString();
        this.getDisplay();
        this.getLocale();
        if (context !== null) {
            this.getDeviceId(context);
        }
    }
    getLocale() {
        let locale = new Intl.Locale();
        let localeID = locale.baseName;
        WaLog.d("localeID: " + localeID);
        this.metrics_locale = localeID;
    }
    getDeviceId(context) {
        let preferences = null;
        try {
            let options = {
                name: 'wa_analytics'
            };
            preferences = dataPreferences.getPreferencesSync(context, options);
            WaLog.i("Succeeded in getting preferences.");
            if (preferences.hasSync('wa_device_id')) {
                let data = preferences.getSync('wa_device_id', 'default');
                WaLog.d("Succeeded in getting wa_device_id " + data);
                if (data != 'default') {
                    this.wa_device_id = data;
                }
                else {
                    if (deviceInfo.ODID !== undefined) {
                        this.wa_device_id = deviceInfo.ODID;
                    }
                    else {
                        this.wa_device_id = generateUUID();
                    }
                    WaLog.d("Save wa_device_id " + this.wa_device_id);
                    preferences.putSync('wa_device_id', this.wa_device_id);
                    preferences.flush();
                }
            }
            else {
                if (deviceInfo.ODID !== undefined) {
                    this.wa_device_id = deviceInfo.ODID;
                }
                else {
                    this.wa_device_id = generateUUID();
                }
                WaLog.d("Save wa_device_id " + this.wa_device_id);
                preferences.putSync('wa_device_id', this.wa_device_id);
                preferences.flush();
            }
        }
        catch (err) {
            WaLog.e("Failed to get preferences. code =" + err.code + ", message =" + err.message);
        }
    }
    printDeviceInfo() {
        WaLog.i("deviceType: " + deviceInfo.deviceType);
        WaLog.i("manufacture: " + deviceInfo.manufacture);
        WaLog.i("brand: " + deviceInfo.brand);
        WaLog.i("marketName: " + deviceInfo.marketName);
        WaLog.i("productSeries: " + deviceInfo.productSeries);
        WaLog.i("productModel: " + deviceInfo.productModel);
        WaLog.i("softwareModel: " + deviceInfo.softwareModel);
        WaLog.i("hardwareModel: " + deviceInfo.hardwareModel);
        WaLog.i("abiList: " + deviceInfo.abiList);
        WaLog.i("displayVersion: " + deviceInfo.displayVersion);
        WaLog.i("osFullName: " + deviceInfo.osFullName);
        WaLog.i("sdkApiVersion: " + deviceInfo.sdkApiVersion);
        WaLog.i("distributionOSName: " + deviceInfo.distributionOSName);
        WaLog.i("ODID: " + deviceInfo.ODID);
    }
    getDisplay() {
        let displayClass = null;
        try {
            displayClass = display.getDefaultDisplaySync();
            WaLog.i("getDefaultDisplaySync" + JSON.stringify(displayClass));
            this.metrics_density = displayClass.densityDPI.toString();
            if (displayClass.xDPI != 0) {
                this.screen_width = displayClass.xDPI.toFixed(3);
            }
            else if (displayClass.scaledDensity != 0) {
                this.screen_width = (displayClass.width / displayClass.scaledDensity).toFixed(3);
                WaLog.i("xDPI为 0, 修正为: " + this.screen_width);
            }
            if (displayClass.yDPI != 0) {
                this.screen_height = displayClass.yDPI.toFixed(3);
            }
            else if (displayClass.scaledDensity != 0) {
                this.screen_height = (displayClass.height / displayClass.scaledDensity).toFixed(3);
                WaLog.i("yDPI为 0, 修正为: " + this.screen_height);
            }
            this.metrics_resolution = `${displayClass.width} * ${displayClass.height}`;
            this.pixelratio = displayClass.scaledDensity.toString();
        }
        catch (exception) {
            WaLog.e('Failed to obtain the default display object. Code: ' + JSON.stringify(exception));
        }
    }
}
