export default class EventManager {
    constructor() {
        this.v3 = new Map();
    }
    on(event, listener) {
        if (!this.v3.has(event)) {
            this.v3.set(event, []);
        }
        this.v3.get(event)?.push(listener);
    }
    off(event, listener) {
        if (!this.v3.has(event)) {
            return;
        }
        const o7 = this.v3.get(event);
        if (o7) {
            this.v3.set(event, o7.filter(l => l !== listener));
        }
    }
    emit(event, args) {
        if (!this.v3.has(event)) {
            return;
        }
        const m7 = this.v3.get(event);
        if (m7) {
            m7.forEach(listener => listener(args));
        }
    }
}
