import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import { CameraPosition } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import { CameraPositionFilter } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraIdFilter&1.2.1'; import hilog from '@ohos:hilog'; export class BaseCameraProvider { constructor(m5, n5) { this.position = m5; this.cameraRepo = n5; } getCameraIdFilter() { return CameraPositionFilter.createCameraPositionFilterWithCameraMap(this.position, this.cameraRepo.getCameraDevices()); } } export class DefaultBackendCameraProvider extends BaseCameraProvider { constructor(l5) { super(CameraPosition.BACKEND, l5); } getCamera() { if (this.position !== CameraPosition.BACKEND) { throw new CameraErrorImpl("DefaultBackendCameraProvider", "position error"); } let k5 = this.getCameraIdFilter().filter(); if (k5.isEmpty()) { throw new CameraErrorImpl("DefaultBackendCameraProvider", "cant get an available backend camera"); } return this.cameraRepo.getCamera(k5.values().next().value); } } export class DefaultFrontCameraProvider extends BaseCameraProvider { constructor(j5) { super(CameraPosition.FRONT, j5); } getCamera() { if (this.position !== CameraPosition.FRONT) { throw new CameraErrorImpl("DefaultFrontCameraProvider", "position error"); } let i5 = this.getCameraIdFilter().filter(); if (i5.isEmpty()) { throw new CameraErrorImpl("DefaultFrontCameraProvider", "cant get an available front camera"); } return this.cameraRepo.getCamera(i5.values().next().value); } } export class DefaultFoldInnerFrontCameraProvider extends BaseCameraProvider { constructor(h5) { super(CameraPosition.FOLD_INNER, h5); } getCameraIdFilter() { return CameraPositionFilter.createCameraPositionFilterWithCameraMap(CameraPosition.FOLD_INNER, this.cameraRepo.getCameraDevices()); } getCamera() { if (this.position !== CameraPosition.FOLD_INNER) { throw new CameraErrorImpl("DefaultFoldInnerFrontCameraProvider", "position error"); } let g5 = this.getCameraIdFilter().filter(); if (g5.isEmpty()) { throw new CameraErrorImpl("DefaultFoldInnerFrontCameraProvider", "cant get an available FoldInnerFront camera"); } return this.cameraRepo.getCamera(g5.values().next().value); } } export class DefaultCameraProvider { constructor(f5) { this.cameraRepo = f5; } getCamera(z4) { let a5 = this.cameraRepo.getCameraDevices().map((e5) => e5.cameraId + ": " + e5.cameraPosition).join("; "); this.cameraRepo.getAvailableCameraIds().forEach((d5) => a5 += `[${d5}]`); hilog.info(0x0000, "CameraX", "Current Camera List " + a5); if (z4 == CameraPosition.FRONT) { return new DefaultFrontCameraProvider(this.cameraRepo).getCamera(); } if (z4 == CameraPosition.FOLD_INNER) { return new DefaultFoldInnerFrontCameraProvider(this.cameraRepo).getCamera(); } return new DefaultBackendCameraProvider(this.cameraRepo).getCamera(); } } 