import { VideoOutputFactory } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/SysOutputFactory&1.2.1'; import camera from "@ohos:multimedia.camera"; import { DefaultVideoProfileSelector } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/CameraProfileSelector&1.2.1'; import HashSet from "@ohos:util.HashSet"; import { SessionState } from '@normalized:N&&&harmonyCameraLib/src/main/ets/camerax/Session&1.2.1'; import { printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import { ExposureMode, Scene } from '@normalized:N&&&harmonyCameraLib/src/main/ets/TypeDefine&1.2.1'; import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import hilog from '@ohos:hilog'; export class VideoSession { constructor(b15, c15) { this.useCaseList = new HashSet(); this.videoOutputList = new HashSet(); this.profileSelector = new DefaultVideoProfileSelector(); this.sessionState = SessionState.INIT; this.onError = (g15) => { printErrorDetail(g15, "VideoSession", "onError"); }; this.cameraInfo = c15; this.manager = b15; this.outputFactory = VideoOutputFactory.createDefaultVideoOutputFactory(b15); this.sysSession = b15.createSession(camera.SceneMode.NORMAL_VIDEO); try { this.sysSession.beginConfig(); this.sessionState = SessionState.BEGIN; } catch (e15) { let f15 = e15; } this.sysSession.on("error", this.onError); } async addOnlineUseCases(o14) { hilog.debug(0x0000, "CameraX", "VideoSession addOnlineUseCaseList"); if (o14.length == 0) { return false; } let p14; try { await this.stop(); } catch (a15) { printErrorDetail(a15, "addOnlineUseCase stop session"); p14 = a15; } o14.forEach((v14) => { let w14 = { targetSize: v14.size, format: v14.format, }; let x14 = v14.getOutputFactory(this.manager); if (x14 == undefined) { x14 = this.outputFactory; } let y14 = x14.getSysOutput(v14.target, w14, Scene.VIDEO, this.cameraInfo); if (this.sysSession.canAddOutput(y14.output)) { try { this.sysSession.addOutput(y14.output); if (x14 instanceof VideoOutputFactory) { this.videoOutputList.add(y14.output); } hilog.debug(0x0000, "CameraX", "VideoSession addOnlineUseCase success"); } catch (z14) { printErrorDetail(z14); } } }); let q14 = await this.sysSession.commitConfig() .then(() => { this.sessionState = SessionState.CONFIGED; return true; }) .catch((u14) => { printErrorDetail(u14, "VideoSession", "addOnlineUseCase commitConfig fail"); return false; }); hilog.debug(0x0000, "CameraX", "VideoSession commitConfig success"); return q14 == true; } async removeOnlineSourceCase(m14) { hilog.debug(0x0000, "CameraX", "Session removeOnlineSourceCase"); try { this.sysSession.beginConfig(); } catch (n14) { printErrorDetail(n14); } this.sysSession.removeInput(m14.getSystemCameraInput()); return true; } async addOnlineSourceCase(l14) { hilog.debug(0x0000, "CameraX", "VideoSession addOnlineSourceCase"); if (this.sysSession.canAddInput(l14.getSystemCameraInput())) { this.sysSession.addInput(l14.getSystemCameraInput()); hilog.debug(0x0000, "CameraX", "VideoSession addOnlineSourceCase success"); return true; } return false; } onFocusStateChange(k14) { } onZoomInfoAvailable(j14) { } async addOnlineUseCase(a14) { hilog.debug(0x0000, "CameraX", "VideoSession addOnlineUseCase"); this.useCaseList.add(a14); if (this.sessionState == SessionState.CONFIGED) { try { this.sysSession.beginConfig(); this.sessionState = SessionState.BEGIN; } catch (i14) { printErrorDetail(i14); return false; } } let b14 = { targetSize: a14.size, format: a14.format, }; let c14 = a14.getOutputFactory(this.manager); if (c14 == undefined) { c14 = this.outputFactory; } let d14 = c14.getSysOutput(a14.target, b14, Scene.VIDEO, this.cameraInfo); if (this.sysSession.canAddOutput(d14.output)) { this.sysSession.addOutput(d14.output); hilog.debug(0x0000, "CameraX", "VideoSession addOnlineUseCase success"); if (c14 instanceof VideoOutputFactory) { this.videoOutputList.add(d14.output); } } if (this.sessionState == SessionState.BEGIN) { let e14 = await this.sysSession.commitConfig().then(() => { this.sessionState = SessionState.CONFIGED; return true; }).catch(async (h14) => { printErrorDetail(h14, "VideoSession", "addOnlineUseCase commitConfig fail"); }); return e14 == true; } return false; } async removeOnlineUseCase(v13) { this.useCaseList.remove(v13); let w13 = v13.getOutputFactory(this.manager); if (w13 == undefined) { w13 = this.outputFactory; } if (!(w13 instanceof VideoOutputFactory)) { return false; } let x13 = w13.getCreatedVideoOutput(); if (x13 == undefined) { return false; } if (!this.videoOutputList.remove(x13)) { return false; } let y13 = false; if (this.sessionState == SessionState.STARTED) { await this.stop(); y13 = true; } try { this.sysSession.beginConfig(); this.sessionState = SessionState.BEGIN; this.sysSession.removeOutput(x13); await this.sysSession.commitConfig(); this.sessionState = SessionState.CONFIGED; hilog.debug(0x0000, "CameraX", "Video removeOnlineUseCase success"); return true; } catch (z13) { printErrorDetail(z13); return false; } finally { if (y13) { hilog.debug(0x0000, "CameraX", "Video session need auto restart"); await this.start(); hilog.debug(0x0000, "CameraX", "Video removeOnlineUseCase success"); } } return false; } async start() { if (this.sessionState != SessionState.CONFIGED) { throw new CameraErrorImpl("VideoSessionIllegelStateError", "Session start", 220); } this.sessionState = SessionState.STARTING; await this.sysSession.start(); this.videoOutputList.forEach((t13) => { try { t13?.start(); } catch (u13) { printErrorDetail(u13); } }); this.sessionState = SessionState.STARTED; try { if (this.sysSession.isExposureModeSupported(camera.ExposureMode.EXPOSURE_MODE_LOCKED)) { let r13 = this.sysSession.getExposureBiasRange(); let s13 = this.sysSession.getExposureValue() + 0.1; if (s13 < r13[r13.length - 1]) { this.sysSession.setExposureBias(0.1); } } } catch (q13) { printErrorDetail(q13); } const n13 = { x: 0.5, y: 0.5 }; try { this.sysSession.setMeteringPoint(n13); } catch (p13) { printErrorDetail(p13); } this.sysSession.setVideoStabilizationMode(camera.VideoStabilizationMode.AUTO); } async stop() { if (this.sessionState == SessionState.STARTED) { this.sessionState = SessionState.STOPING; this.videoOutputList.forEach((l13) => { try { l13?.stop(); } catch (m13) { printErrorDetail(m13); } }); await this.sysSession.stop().catch((k13) => printErrorDetail(k13)); this.sessionState = SessionState.STOPED; } } async release() { this.videoOutputList.forEach((g13) => { try { g13?.release(); } catch (h13) { printErrorDetail(h13); } }); await this.sysSession.release().catch(); this.sysSession.off("error", this.onError); } isFocusModeSupported(e13) { return this.sysSession.isFlashModeSupported(e13.valueOf()); } getFocusMode() { return this.sysSession.getFocusMode().valueOf(); } setFocusMode(d13) { this.sysSession.setFocusMode(d13.valueOf()); } setFocusPoint(c13) { this.sysSession.setFocusPoint(c13); } getFocusPoint() { return this.sysSession.getFocusPoint(); } getFocalLength() { return this.sysSession.getFocalLength(); } hasFlash() { return this.hasFlash(); } isFlashModeSupported(b13) { return this.sysSession.isFlashModeSupported(b13.valueOf()); } getFlashMode() { return this.sysSession.getFocusMode().valueOf(); } setFlashMode(a13) { return this.sysSession.setFlashMode(a13.valueOf()); } isExposureModeSupported(z12 = ExposureMode.AUTO) { return this.sysSession.isExposureModeSupported(camera.ExposureMode.EXPOSURE_MODE_AUTO); } getExposureMode() { return ExposureMode.AUTO; } setExposureMode(y12) { this.sysSession.setExposureMode(y12.valueOf()); } getMeteringPoint() { throw new Error('Method not implemented.'); } setMeteringPoint(x12) { throw new Error('Method not implemented.'); } getExposureBiasRange() { throw new Error('Method not implemented.'); } setExposureBias(w12) { this.sysSession.setExposureBias(w12); } getExposureValue() { return this.sysSession.getExposureValue(); } getZoomRatioRange() { throw new Error('Method not implemented.'); } getZoomRatio() { throw new Error('Method not implemented.'); } setZoomRatio(v12) { throw new Error('Method not implemented.'); } setSmoothZoom(t12, u12) { throw new Error('Method not implemented.'); } onUseCaseActive(s12) { this.useCaseList.add(s12); } onUseCaseInactive(r12) { this.useCaseList.remove(r12); } onUseCaseUpdated(q12) { throw new Error('Method not implemented.'); } onUseCaseReset(p12) { throw new Error('Method not implemented.'); } } 