import camera from "@ohos:multimedia.camera"; import { WeCameraSession } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/WeCameraSession&1.2.1'; import { WeCameraDevice } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/WeCameraDevice&1.2.1'; import { convertSceneType, printErrorDetail } from '@normalized:N&&&harmonyCameraLib/src/main/ets/Utils&1.2.1'; import { CameraErrorImpl } from '@normalized:N&&&harmonyCameraLib/src/main/ets/internal/CameraErrorImpl&1.2.1'; import hilog from '@ohos:hilog'; class DeviceSelectKey { constructor(y18, z18, a19) { this.type = y18; this.position = z18; this.scene = a19; } generateKey() { return `${this.type}_${this.position}_${this.scene}`; } } export class WeCameraImpl { constructor(w18, x18) { this.sysCameraManager = w18; this.initAllCameraDevice(); } addOnCameraClosedListener(v18) { this.listener = v18; } async startCamera(m18) { hilog.debug(0x0000, "CameraX", `WeCameraImpl startCamera config: ${m18.toString()}`); if (this.session !== undefined) { await this.session.releaseSession(); this.session = undefined; } let n18 = this.getCameraSession(convertSceneType(m18.scene)); if (n18 == undefined) { throw new CameraErrorImpl('WeCameraImpl', 'Cannot create camera session'); } let o18 = new DeviceSelectKey(m18.cameraType, m18.cameraPosition, m18.scene); let p18 = this.getCameraDevice(o18); if (p18 == undefined) { throw new CameraErrorImpl('WeCameraImpl', 'Cannot get system camera device'); } if (this.listener !== undefined) { p18?.addSysInterruptListener(this.listener); } let q18 = p18.getSysCameraInput(); if (q18 == undefined) { throw new CameraErrorImpl('WeCameraImpl', 'Cannot create cameraInput'); } await p18.open(); let r18 = await p18.getPreviewOutput(m18.previewConfig, convertSceneType(m18.scene)); if (r18 == undefined) { throw new CameraErrorImpl('WeCameraImpl', 'Cannot get camera previewOutput'); } r18.on("frameStart", async () => { hilog.debug(0x0000, "CameraX", "WeCameraImpl frameStart"); }); r18.on("frameEnd", async () => { hilog.debug(0x0000, "CameraX", "WeCameraImpl frameEnd"); }); let s18; if (m18.outputConfig !== undefined) { s18 = await p18.getPreviewOutput(m18.outputConfig, convertSceneType(m18.scene)); } this.session = new WeCameraSession(p18, n18, r18, s18); await this.session.config(); await this.session.start(); } hasCameraSession() { return this.session != undefined; } getCameraSession(k18) { let l18 = (k18 == camera.SceneMode.NORMAL_PHOTO) ? this.sysCameraManager.createSession(k18) : this.sysCameraManager.createSession(k18); return l18; } initAllCameraDevice() { try { if (WeCameraImpl.cameraDeviceArray.length <= 0) { WeCameraImpl.cameraDeviceArray = this.sysCameraManager.getSupportedCameras(); } } catch (j18) { printErrorDetail(j18); } } getCameraDevice(b18) { let c18 = b18.generateKey(); if (!WeCameraImpl.deviceMap.has(c18)) { let d18 = convertSceneType(b18.scene); let e18 = WeCameraImpl.cameraDeviceArray.filter((i18) => i18.cameraPosition.valueOf() == b18.position.valueOf() && i18.cameraType.valueOf() == b18.type.valueOf() && this.sysCameraManager.getSupportedSceneModes(i18).indexOf(d18) >= 0); if (e18.length > 0) { let g18 = e18[0]; let h18 = new WeCameraDevice(this.sysCameraManager, g18); WeCameraImpl.deviceMap.set(c18, h18); } } return WeCameraImpl.deviceMap.get(c18); } async stopCamera() { await this.session?.stop(); } async releaseCamera() { await this.session?.releaseSession(); } } WeCameraImpl.cameraDeviceArray = []; WeCameraImpl.deviceMap = new Map(); 