import { exec_cpp_sync, mgr, register_js_callback, asyncWork, registerLogListener } from '@normalized:Y&&&libwbkycytwrapper.so&';
import { WBLogAdapter } from '@normalized:N&&&wbkycytwrapper/src/main/ets/Log&1.2.0';
export class JSChannel {
    static get() {
        if (!JSChannel.instance) {
            JSChannel.instance = new JSChannel();
        }
        return JSChannel.instance;
    }
    init(m) {
        register_js_callback("log", m);
    }
    initRes(l) {
        mgr(l.resourceManager);
    }
    register(j, k) {
        register_js_callback(j, k);
    }
    invokeSync(g, h) {
        let i = new ArrayBuffer(0);
        if (typeof h === 'string') {
            return exec_cpp_sync(g, h);
        }
        else if (typeof h === 'undefined') {
            i = new ArrayBuffer(0);
        }
        else {
            i = h;
        }
        return exec_cpp_sync(g, i);
    }
    registerLogHandle(e = undefined) {
        let f = WBLogAdapter.getInstance();
        if (e) {
            f.setLogsListener(e);
        }
        registerLogListener(f);
    }
    invokeAsync(a, b, c) {
        let d = new ArrayBuffer(0);
        if (typeof b === 'string') {
            return asyncWork(a, b, c);
        }
        else if (typeof b === 'undefined') {
            d = new ArrayBuffer(0);
        }
        else {
            d = b;
        }
        return asyncWork(a, d, c);
    }
}
