import { DefaultAPI, DefaultBackupAPI } from "./b/r";
import { DomainEnvironment } from "./b/DomainEnvironment";
export default class Config {
    constructor(app_id, sub_app_id, setMainInstance, identifier) {
        this._mainUrl = DefaultAPI;
        this._backupUrl = DefaultBackupAPI;
        this.useTraditionalPageViewMode = false;
        this.app_id = app_id;
        if (sub_app_id) {
            this.sub_app_id = sub_app_id;
        }
        else {
            this.sub_app_id = this.app_id;
        }
        let id = identifier ?? `${this.app_id}_${this.sub_app_id}`;
        this.identifier = id;
        this.setMainInstance = setMainInstance;
    }
    setDomainEnvironment(domain) {
        this._mainUrl = DomainEnvironment.mainURL(domain);
        this._backupUrl = DomainEnvironment.backupURL(domain);
    }
    setBaseUrl(mainUrl, backupUrl) {
        this._mainUrl = mainUrl;
        this._backupUrl = backupUrl;
    }
    get mainUrl() {
        return this._mainUrl;
    }
    get backupUrl() {
        return this._backupUrl;
    }
}
