import { DataType, TrackModelAbstractClass } from "./x";
export default class LogModel extends TrackModelAbstractClass {
    constructor(log_level, log_name, log_msg) {
        super();
        this.data_type = DataType.Log;
        this.log_level = log_level;
        this.log_name = log_name;
        this.log_msg = log_msg;
    }
    toRecord() {
        const record = {};
        record.time_stamp = this.time_stamp;
        record.data_type = this.data_type;
        if (this.trace_id) {
            record.trace_id = this.trace_id;
        }
        if (this.growth_id) {
            record.growth_id = this.growth_id;
        }
        if (this.log_level) {
            record.log_level = this.log_level;
        }
        if (this.log_name) {
            record.log_name = this.log_name;
        }
        if (this.log_msg) {
            record.log_msg = this.log_msg;
        }
        const keys = Object.keys(this.props);
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            const value = this.props[key];
            if (value !== null) {
                record[key] = value;
            }
        }
        return record;
    }
}
