import HashMap from "@ohos.util.HashMap"; import HashSet from "@ohos.util.HashSet"; import { CameraStatus } from './BaseCamera'; import { CameraErrorImpl } from '../internal/CameraErrorImpl'; import camera from "@ohos.multimedia.camera"; import { convertIteratorToSet, printErrorDetail } from '../Utils'; import hilog from '@ohos.hilog'; export class CameraRepository { constructor() { this.TAG = "CameraRepository"; this.activeCameraIdRepo = new HashMap(); this.availableCameraStore = new HashMap(); this.foldInfoListener = (h7, i7) => { if (h7 !== undefined && h7.code !== 0) { hilog.error(0x0000, "CameraX", 'foldStatusChange with errorCode = ' + h7.code); return; } hilog.info(0x0000, "CameraX", `Camera foldStatus change refresh supported cameras`); this.availableCameraStore.clear(); i7.supportedCameras.forEach((k7) => { if (k7 !== undefined && this.sysManager != undefined) { this.availableCameraStore.set(k7.cameraId, k7); hilog.info(0x0000, "CameraX", `Camera foldStatus supported camera: ${k7.cameraId} position: ${k7.cameraPosition}`); } }); }; this.onCameraUpdate = (c7, d7) => { hilog.debug(0x0000, this.TAG, `DefaultCameraFactory onCameraStatus update: cameraId: ${d7.camera.cameraId} status: ${d7.status}`); if (c7 !== undefined) { printErrorDetail(c7); } if (d7 !== undefined) { let e7 = d7.camera.cameraId; if (d7.status == camera.CameraStatus.CAMERA_STATUS_UNAVAILABLE) { let g7 = this.activeCameraIdRepo.hasKey(e7); if (this.availableCameraStore.hasKey(e7)) { this.availableCameraStore.remove(e7); } hilog.debug(0x0000, this.TAG, `CameraRepository onCameraStatus update: cameraId: ${d7.camera.cameraId} status: ${d7.status}, hasActiveCamera: ${g7} `); } else if (d7.status == camera.CameraStatus.CAMERA_STATUS_AVAILABLE) { hilog.debug(0x0000, this.TAG, `CameraRepository onCameraStatus AVAILABLE: cameraId: ${d7.camera.cameraId} status: ${d7.status} `); let f7 = this.activeCameraIdRepo.get(e7); if (f7 !== undefined) { hilog.debug(0x0000, this.TAG, `CameraRepository onCameraStatus AVAILABLE, notify baseCamera`); f7.updateCameraStatus(CameraStatus.AVAILABLE); } if (this.availableCameraStore.get(e7) == undefined) { if (this.cameraFactory == undefined) { throw new CameraErrorImpl("CameraRepository", "onCameraUpdate fail: cameraFactory cant be empty, call init function firstly"); } this.availableCameraStore.set(e7, d7.camera); } } else { this.availableCameraStore.remove(e7); } } this.debugPrintCameraMapInfo(); }; } getCameraDevices() { let v6 = new Array(); if (this.sysManager != undefined) { this.availableCameraStore.clear(); this.sysManager.getSupportedCameras().forEach((z6) => { if (z6 !== undefined) { this.availableCameraStore.set(z6.cameraId, z6); } }); } this.availableCameraStore.forEach((x6) => { if (x6 != undefined) { v6.push(x6); } }); return v6; } onAbilityForeground() { this.activeCameraIdRepo.forEach((t6, u6) => { t6?.onAbilityForeground(); }); } onWindowStageActive() { this.activeCameraIdRepo.forEach((q6, r6) => { q6?.onWindowStageActive(); }); } onWindowStageInactive() { this.activeCameraIdRepo.forEach((n6, o6) => { n6?.onWindowStageInactive(); }); } init(i6, j6) { hilog.debug(0x0000, this.TAG, "CameraRepository init"); this.cameraFactory = i6; this.sysManager = camera.getCameraManager(j6.getApplicationContext()); this.sysManager.getSupportedCameras().forEach((l6) => { if (l6 !== undefined) { this.availableCameraStore.set(l6.cameraId, l6); } }); this.sysManager?.on("cameraStatus", this.onCameraUpdate); this.sysManager?.on("foldStatusChange", this.foldInfoListener); } dispose() { this.sysManager?.off("cameraStatus", this.onCameraUpdate); this.sysManager?.off("foldStatusChange", this.foldInfoListener); } debugPrintCameraMapInfo() { this.availableCameraStore.forEach((g6, h6) => hilog.debug(0x0000, this.TAG, 'availableCameraMap: %{public}s', `cameraId: ${h6}`)); this.activeCameraIdRepo.forEach((e6, f6) => { hilog.debug(0x0000, this.TAG, 'activeCameraIdRepo %{public}s', `cameraId: ${f6}`); }); } getCamera(b6) { if (this.cameraFactory == undefined) { throw new CameraErrorImpl("CameraRepository", "init function need be called firstly"); } this.debugPrintCameraMapInfo(); return this.cameraFactory.getCamera(this.availableCameraStore.get(b6)); } getAllCameraIds() { if (this.cameraFactory == undefined) { throw new CameraErrorImpl("CameraRepository", "init function need be called firstly"); } let x5 = new HashSet(); for (const a6 of this.availableCameraStore.keys()) { x5.add(a6); } this.sysManager?.getSupportedCameras().forEach((z5) => { x5.add(z5.cameraId); }); return x5; } getActiveCameraIds() { return convertIteratorToSet(this.activeCameraIdRepo.keys()); } getAvailableCameraIds() { let u5 = new HashSet(); for (const w5 of this.activeCameraIdRepo.keys()) { u5.add(w5); } for (const v5 of this.availableCameraStore.keys()) { u5.add(v5); } return u5; } onGroupActive(t5) { throw new Error('Method not implemented.'); } onGroupInactive(s5) { throw new Error('Method not implemented.'); } onCameraActive(q5) { let r5 = q5.getCameraInfo().getCameraId(); this.activeCameraIdRepo.set(r5, q5); } onCameraInactive(o5) { let p5 = o5.getCameraInfo().getCameraId(); this.activeCameraIdRepo.remove(p5); this.debugPrintCameraMapInfo(); } } 