/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.request.SignFilePdfParam;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.util.CollectionUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.exception.SuperException;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformSignParam {
    private SignFilePdfParam fileBean;
    private List<PosBean> posBeans;
    private String sealData;
    private String sealId;
    private SignType signType;

    public SignFilePdfParam getFileBean() {
        return this.fileBean;
    }

    public void setFileBean(SignFilePdfParam fileBean) {
        this.fileBean = fileBean;
    }

    public List<PosBean> getPosBeans() {
        return this.posBeans;
    }

    public void setPosBeans(List<PosBean> posBeans) {
        this.posBeans = posBeans;
    }

    public String getSealData() {
        return this.sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public String getSealId() {
        return this.sealId;
    }

    public void setSealId(String sealId) {
        this.sealId = sealId;
    }

    public SignType getSignType() {
        return this.signType;
    }

    public void setSignType(SignType signType) {
        this.signType = signType;
    }

    public void check() throws SuperException {
        this.checkSignParam();
        ValidationUtil.check(StringUtils.isBlank(this.sealData) && StringUtils.isBlank(this.sealId), ErrorException.SIGN_SEAL_ID_NULL_ERROR.e());
    }

    private void checkSignParam() throws SuperException {
        ValidationUtil.check(this.fileBean == null, ErrorException.FILE_STREAM_ERROR.e());
        this.fileBean.check();
        ValidationUtil.check(CollectionUtil.isEmpty(this.posBeans), ErrorException.POSBEANS_NULL_ERROR.e());
        ValidationUtil.check(this.signType == null, ErrorException.SIGN_TYPE_NULL_ERROR.e());
    }
}

