/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.bean.model.AuthFlowUrlModel;
import com.timevale.esign.paas.tech.bean.model.CancelAuthModel;
import com.timevale.esign.paas.tech.bean.model.CreateAuthModel;
import com.timevale.esign.paas.tech.bean.model.QueryAuthDetailModel;
import com.timevale.esign.paas.tech.bean.request.AuthFlowSignUrlParam;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateAuthParam;
import com.timevale.esign.paas.tech.bean.result.AuthFlowSignUrlResult;
import com.timevale.esign.paas.tech.bean.result.AuthInfoResult;
import com.timevale.esign.paas.tech.bean.result.OnlineCreateAuthResult;
import com.timevale.esign.paas.tech.bean.result.Result;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.AuthMethodEnum;
import com.timevale.esign.paas.tech.service.AuthService;
import com.timevale.esign.paas.tech.service.a.a;
import esign.utils.JsonHelper;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.SuperException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class d
extends a
implements AuthService {
    private static Logger log = LoggerFactory.getLogger(d.class);

    public d() {
    }

    public d(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public OnlineCreateAuthResult createAuth(OnlineCreateAuthParam param) {
        try {
            param.check();
            CreateAuthModel createAuthModel = (CreateAuthModel)this.vk().getContext().a(InterfaceKey.CREATE_AUTH);
            createAuthModel.setOrganizeId(param.getOrganizeId());
            createAuthModel.setPersonId(param.getPersonId());
            createAuthModel.setAuthType(param.getAuthType());
            createAuthModel.setAuthMethod(AuthMethodEnum.ONLINE_AUTH.getType());
            createAuthModel.setContact(param.getContact());
            createAuthModel.setSealScope(param.getSealScope());
            createAuthModel.setFileType(param.getFileType());
            createAuthModel.setValidDate(param.getValidDate());
            createAuthModel.setCallbackUrl(param.getNotifyUrl());
            createAuthModel.setRedirectUrl(param.getRedirectUrl());
            createAuthModel.setSendNotice(param.isSendNotice());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vk(), createAuthModel);
            OnlineCreateAuthResult onlineCreateAuthResult = JsonHelper.fromJson(jsonObject, OnlineCreateAuthResult.class);
            if (onlineCreateAuthResult.getErrCode() != 0) {
                return ResultUtil.failed(onlineCreateAuthResult, OnlineCreateAuthResult.class);
            }
            return onlineCreateAuthResult;
        }
        catch (SuperException superException) {
            log.warn("createAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, OnlineCreateAuthResult.class);
        }
        catch (Exception exception) {
            log.warn("createAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_AUTH_FAIL.e(exception.getMessage()), OnlineCreateAuthResult.class);
        }
    }

    @Override
    public Result cancel(String authId) {
        try {
            if (StringUtils.isBlank((String)authId)) {
                throw ErrorCode.PARAM_ERROR.e("\u6388\u6743id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            CancelAuthModel cancelAuthModel = (CancelAuthModel)this.vk().getContext().a(InterfaceKey.CANCEL_AUTH);
            cancelAuthModel.setAuthId(authId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vk(), cancelAuthModel);
            Result result = JsonHelper.fromJson(jsonObject, Result.class);
            if (result.getErrCode() != 0) {
                return ResultUtil.failed(result, Result.class);
            }
            return result;
        }
        catch (SuperException superException) {
            log.warn("cancelAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.warn("cancelAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CANCEL_AUTH_FAIL.e(exception.getMessage()), Result.class);
        }
    }

    @Override
    public AuthInfoResult queryAuth(String authId) {
        try {
            if (StringUtils.isBlank((String)authId)) {
                throw ErrorCode.PARAM_ERROR.e("\u6388\u6743id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            QueryAuthDetailModel queryAuthDetailModel = (QueryAuthDetailModel)this.vk().getContext().a(InterfaceKey.QUERY_AUTH_DETAIL);
            queryAuthDetailModel.setAuthId(authId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vk(), queryAuthDetailModel);
            AuthInfoResult authInfoResult = JsonHelper.fromJson(jsonObject, AuthInfoResult.class);
            if (authInfoResult.getErrCode() != 0) {
                return ResultUtil.failed(authInfoResult, AuthInfoResult.class);
            }
            return authInfoResult;
        }
        catch (SuperException superException) {
            log.warn("queryAuthDetail fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AuthInfoResult.class);
        }
        catch (Exception exception) {
            log.warn("queryAuthDetail Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.QUERY_AUTH_FAIL.e(exception.getMessage()), AuthInfoResult.class);
        }
    }

    @Override
    public AuthFlowSignUrlResult getAuthFlowUrl(AuthFlowSignUrlParam param) {
        try {
            param.check();
            AuthFlowUrlModel authFlowUrlModel = (AuthFlowUrlModel)this.vk().getContext().a(InterfaceKey.GET_SIGN_URL);
            authFlowUrlModel.setAuthId(param.getAuthId());
            authFlowUrlModel.setClientType(param.getClientType());
            authFlowUrlModel.setAppScheme(param.getAppScheme());
            authFlowUrlModel.setRedirectUrl(param.getRedirectUrl());
            authFlowUrlModel.setNeedLogin(param.getNeedLogin());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vk(), authFlowUrlModel);
            AuthFlowSignUrlResult authFlowSignUrlResult = JsonHelper.fromJson(jsonObject, AuthFlowSignUrlResult.class);
            if (authFlowSignUrlResult.getErrCode() != 0) {
                return ResultUtil.failed(authFlowSignUrlResult, AuthFlowSignUrlResult.class);
            }
            return authFlowSignUrlResult;
        }
        catch (SuperException superException) {
            log.warn("getAuthFlowUrl fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AuthFlowSignUrlResult.class);
        }
        catch (Exception exception) {
            log.warn("getAuthFlowUrl Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(exception, AuthFlowSignUrlResult.class);
        }
    }
}

