/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BstAggregate;
import com.timevale.guava.common.collect.BstBalancePolicy;
import com.timevale.guava.common.collect.BstNode;
import com.timevale.guava.common.collect.BstNodeFactory;
import com.timevale.guava.common.collect.BstPath;
import com.timevale.guava.common.collect.BstPathFactory;
import com.timevale.guava.common.collect.BstSide;
import com.timevale.guava.common.collect.GeneralRange;
import javax.annotation.Nullable;

@GwtCompatible
final class BstRangeOps {
    public static <K, N extends BstNode<K, N>> int totalInRange(BstAggregate<? super N> aggregate, GeneralRange<K> range, @Nullable N root) {
        Preconditions.checkNotNull(aggregate);
        Preconditions.checkNotNull(range);
        if (root == null || range.isEmpty()) {
            return 0;
        }
        int n2 = aggregate.treeValue(root);
        if (range.hasLowerBound()) {
            n2 -= BstRangeOps.totalBeyondRangeToSide(aggregate, range, BstSide.LEFT, root);
        }
        if (range.hasUpperBound()) {
            n2 -= BstRangeOps.totalBeyondRangeToSide(aggregate, range, BstSide.RIGHT, root);
        }
        return n2;
    }

    private static <K, N extends BstNode<K, N>> int totalBeyondRangeToSide(BstAggregate<? super N> aggregate, GeneralRange<K> range, BstSide side, @Nullable N root) {
        int n2 = 0;
        while (root != null) {
            if (BstRangeOps.beyond(range, root.getKey(), side)) {
                n2 += aggregate.entryValue(root);
                n2 += aggregate.treeValue(root.childOrNull(side));
                root = root.childOrNull(side.other());
                continue;
            }
            root = root.childOrNull(side);
        }
        return n2;
    }

    @Nullable
    public static <K, N extends BstNode<K, N>> N minusRange(GeneralRange<K> range, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory, @Nullable N root) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(balancePolicy);
        Preconditions.checkNotNull(nodeFactory);
        Object n2 = range.hasUpperBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.RIGHT, root) : null;
        Object n3 = range.hasLowerBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.LEFT, root) : null;
        return balancePolicy.combine(nodeFactory, n3, n2);
    }

    @Nullable
    private static <K, N extends BstNode<K, N>> N subTreeBeyondRangeToSide(GeneralRange<K> range, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory, BstSide side, @Nullable N root) {
        if (root == null) {
            return null;
        }
        if (BstRangeOps.beyond(range, root.getKey(), side)) {
            N n2 = root.childOrNull(BstSide.LEFT);
            N n3 = root.childOrNull(BstSide.RIGHT);
            switch (side) {
                case LEFT: {
                    n3 = BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.LEFT, n3);
                    break;
                }
                case RIGHT: {
                    n2 = BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.RIGHT, n2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return balancePolicy.balance(nodeFactory, root, n2, n3);
        }
        return BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, side, root.childOrNull(side));
    }

    @Nullable
    public static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> range, BstSide side, BstPathFactory<N, P> pathFactory, @Nullable N root) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(pathFactory);
        Preconditions.checkNotNull(side);
        if (root == null) {
            return null;
        }
        P p2 = pathFactory.initialPath(root);
        return BstRangeOps.furthestPath(range, side, pathFactory, p2);
    }

    private static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> range, BstSide side, BstPathFactory<N, P> pathFactory, P currentPath) {
        N n2 = currentPath.getTip();
        K k2 = ((BstNode)n2).getKey();
        if (BstRangeOps.beyond(range, k2, side)) {
            if (((BstNode)n2).hasChild(side.other())) {
                currentPath = pathFactory.extension(currentPath, side.other());
                return BstRangeOps.furthestPath(range, side, pathFactory, currentPath);
            }
            return null;
        }
        if (((BstNode)n2).hasChild(side)) {
            P p2 = pathFactory.extension(currentPath, side);
            if ((p2 = BstRangeOps.furthestPath(range, side, pathFactory, p2)) != null) {
                return p2;
            }
        }
        return BstRangeOps.beyond(range, k2, side.other()) ? null : (P)currentPath;
    }

    public static <K> boolean beyond(GeneralRange<K> range, K key, BstSide side) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(key);
        switch (side) {
            case LEFT: {
                return range.tooLow(key);
            }
            case RIGHT: {
                return range.tooHigh(key);
            }
        }
        throw new AssertionError();
    }

    private BstRangeOps() {
    }
}

