/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.request.generator.impl;

import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.CenterTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.EllipseInnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.HengTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.SerialTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.SurroundTextInfo;
import com.timevale.seal.sdk.enums.CenterTypeEnum;
import com.timevale.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.seal.sdk.enums.FontEnum;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.request.EllipseSealRequest;
import com.timevale.seal.sdk.request.SealBaseRequest;
import com.timevale.seal.sdk.request.generator.AbstractRequestGenerator;
import com.timevale.seal.sdk.util.FontUtil;
import com.timevale.seal.sdk.util.PixelUtil;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Font;
import java.util.List;

public class EllipseImageRequestGenerator
extends AbstractRequestGenerator {
    private static final int STAR_DEFAULT_SIZE = 14;

    @Override
    protected <T extends SealBaseRequest, R extends InnerRequest> void convertDetail(T t2, R r2) {
        EllipseInnerRequest ellipseInnerRequest = (EllipseInnerRequest)r2;
        EllipseSealRequest ellipseSealRequest = (EllipseSealRequest)t2;
        ellipseInnerRequest.setDrawRuleTypeEnum(ellipseSealRequest.getDrawRuleTypeEnum());
        this.buildTopSurroundInfo(ellipseSealRequest, ellipseInnerRequest);
        this.buildCenterInfo(ellipseSealRequest, ellipseInnerRequest);
        this.buildHengTextInfo(ellipseSealRequest, ellipseInnerRequest);
        this.buildSerialTextInfo(ellipseSealRequest, ellipseInnerRequest);
        this.buildBottomSurroundTextInfo(ellipseSealRequest, ellipseInnerRequest);
    }

    private void buildBottomSurroundTextInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        String string = outRequest.getBottomSurroundText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        SurroundTextInfo surroundTextInfo = new SurroundTextInfo();
        surroundTextInfo.setText(string);
        surroundTextInfo.setWidth(PixelUtil.transferMmToPixel(1.0f, innerRequest.getDpi()));
        surroundTextInfo.setHeight(PixelUtil.transferMmToPixel(1.2f, innerRequest.getDpi()));
        surroundTextInfo.setArcAng(75);
        surroundTextInfo.setMinRat(-0.25f);
        surroundTextInfo.setScaleX(1.0);
        this.customBottomSurroundTextInfo(surroundTextInfo, outRequest);
        if (null == surroundTextInfo.getFont()) {
            surroundTextInfo.setFont(FontUtil.processFont(outRequest.getBottomSurroundTextFont(), 1, 34));
        }
        innerRequest.setBottomSurroundTextInfo(surroundTextInfo);
    }

    protected void customBottomSurroundTextInfo(SurroundTextInfo textInfo, EllipseSealRequest outRequest) {
    }

    private void buildSerialTextInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        String string = outRequest.getSerialText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        SerialTextInfo serialTextInfo = new SerialTextInfo();
        serialTextInfo.setText(string);
        serialTextInfo.setFont(FontUtil.processFont(outRequest.getSerialTextFont(), 0, 10));
        this.customSerialTextInfo(serialTextInfo, innerRequest);
        innerRequest.setSerialTextInfo(serialTextInfo);
    }

    protected void customSerialTextInfo(SerialTextInfo serialTextInfo, EllipseInnerRequest innerRequest) {
    }

    protected void buildHengTextInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        String string = outRequest.getHorizontalText();
        List<String> list = outRequest.getHorizontalTestList();
        if (StringUtils.isBlank(string)) {
            if (list == null || list.isEmpty()) {
                return;
            }
            if (list.size() == 1) {
                string = list.get(0);
                list = null;
            }
        }
        HengTextInfo hengTextInfo = new HengTextInfo();
        hengTextInfo.setText(string);
        hengTextInfo.setTextList(list);
        hengTextInfo.setFont(FontUtil.processFont(outRequest.getHorizontalTextFont(), 1, 51));
        this.customHengTextInfo(hengTextInfo, innerRequest);
        innerRequest.setHengTextInfo(hengTextInfo);
    }

    protected void customHengTextInfo(HengTextInfo textInfo, EllipseInnerRequest innerRequest) {
    }

    protected void buildTopSurroundInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        String string = outRequest.getTopSurroundText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        SurroundTextInfo surroundTextInfo = new SurroundTextInfo();
        surroundTextInfo.setText(string);
        int n2 = this.getTopSurroundFontSize(innerRequest.getWidth(), innerRequest.getHeight(), string.length(), innerRequest.getDrawRuleTypeEnum());
        surroundTextInfo.setFont(FontUtil.processFont(outRequest.getTopSurroundTextFont(), 1, n2));
        surroundTextInfo.setScaleX(this.getTopSurroundTextScaleX(string.length(), innerRequest.getDrawRuleTypeEnum()));
        surroundTextInfo.setArcAng(250);
        surroundTextInfo.setMinRat(0.2f);
        innerRequest.setTopSurroundTextInfo(surroundTextInfo);
    }

    protected int getTopSurroundFontSize(int width, int height, int length, DrawRuleTypeEnum drawRuleTypeEnum) {
        int n2 = 100;
        int n3 = 15;
        if (width == height) {
            if (DrawRuleTypeEnum.CONTRACT.equals((Object)drawRuleTypeEnum) || DrawRuleTypeEnum.PERSONNEL.equals((Object)drawRuleTypeEnum) || DrawRuleTypeEnum.FINANCE.equals((Object)drawRuleTypeEnum)) {
                n2 = 90;
                n3 = 18;
            } else if (width != 662) {
                n3 = 13;
            }
            if (length > n3) {
                n2 -= length - n3;
            }
        } else {
            n2 = 80;
            n3 = 14;
            if (length > n3) {
                n2 -= length - n3;
            }
        }
        return n2;
    }

    protected double getTopSurroundTextScaleX(int length, DrawRuleTypeEnum drawRuleTypeEnum) {
        double d2 = DrawRuleTypeEnum.CONTRACT.equals((Object)drawRuleTypeEnum) || DrawRuleTypeEnum.PERSONNEL.equals((Object)drawRuleTypeEnum) || DrawRuleTypeEnum.FINANCE.equals((Object)drawRuleTypeEnum) ? (length < 15 ? 0.55 : 0.55 - (double)(length - 15) * 0.01) : (DrawRuleTypeEnum.BUSINESS.equals((Object)drawRuleTypeEnum) ? (length < 15 ? 0.7 : 0.7 - (double)(length - 15) * 0.015) : (DrawRuleTypeEnum.PUBLIC_DOUBLE.equals((Object)drawRuleTypeEnum) ? (length < 15 ? 0.46 : (length < 36 ? 0.4 - (double)(length - 14) * 0.008 : 0.48)) : (length < 15 ? 0.7 : 0.62 - (double)(length - 14) * 0.012)));
        return d2;
    }

    protected void buildCenterInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        CenterTypeEnum centerTypeEnum = outRequest.getCenterTypeEnum();
        if (CenterTypeEnum.NONE.equals((Object)centerTypeEnum)) {
            return;
        }
        if (CenterTypeEnum.STAR.equals((Object)centerTypeEnum)) {
            CenterTextInfo centerTextInfo = new CenterTextInfo();
            centerTextInfo.setCenterTypeEnum(centerTypeEnum);
            centerTextInfo.setText("\u2605");
            Font font = FontUtil.loadFont(FontEnum.SONG.getCode());
            centerTextInfo.setFont(FontUtil.processFont(font, 0, 50));
            centerTextInfo.setWidth(PixelUtil.transferMmToPixel(14.0f, innerRequest.getDpi()));
            centerTextInfo.setTotalWidth(centerTextInfo.getWidth());
            centerTextInfo.setHeight(centerTextInfo.getWidth());
            innerRequest.setCenterTextInfo(centerTextInfo);
        } else if (CenterTypeEnum.NUMBER.equals((Object)centerTypeEnum)) {
            CenterTextInfo centerTextInfo = new CenterTextInfo();
            centerTextInfo.setCenterTypeEnum(centerTypeEnum);
            centerTextInfo.setText(outRequest.getCenterContent());
            centerTextInfo.setFont(FontUtil.processFont(outRequest.getCenterContentFont(), 0, 50));
            centerTextInfo.setWidth(PixelUtil.transferMmToPixel(1.3f, innerRequest.getDpi()));
            centerTextInfo.setTotalWidth(PixelUtil.transferMmToPixel(26.0f, innerRequest.getDpi()));
            centerTextInfo.setHeight(PixelUtil.transferMmToPixel(3.7f, innerRequest.getDpi()));
            innerRequest.setCenterTextInfo(centerTextInfo);
        }
    }

    @Override
    protected InnerRequest getImageRequest() {
        return new EllipseInnerRequest();
    }

    @Override
    protected <T extends SealBaseRequest> void validateRequest(T t2) {
        super.validateRequest(t2);
        EllipseSealRequest ellipseSealRequest = (EllipseSealRequest)t2;
        DrawRuleTypeEnum drawRuleTypeEnum = ellipseSealRequest.getDrawRuleTypeEnum();
        if (drawRuleTypeEnum == null) {
            ellipseSealRequest.setDrawRuleTypeEnum(DrawRuleTypeEnum.COMMON);
        }
        this.validateTopSurroundText(ellipseSealRequest);
        this.validateCenterInfo(ellipseSealRequest);
        this.validateHorizontalText(ellipseSealRequest);
        this.validateSerialText(ellipseSealRequest);
        this.validateBottomSurroundText(ellipseSealRequest);
    }

    private void validateBottomSurroundText(EllipseSealRequest outRequest) {
        String string = outRequest.getBottomSurroundText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (null == outRequest.getBottomSurroundTextFont()) {
            throw new SealSdkException("\u6ca1\u6709\u6307\u5b9a\u4e0b\u5f26\u6587\u5b57\u4f53");
        }
    }

    private void validateSerialText(EllipseSealRequest outRequest) {
        String string = outRequest.getSerialText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (null == outRequest.getSerialTextFont()) {
            throw new SealSdkException("\u6ca1\u6709\u6307\u5b9a\u5e8f\u5217\u53f7\u5b57\u4f53");
        }
    }

    private void validateHorizontalText(EllipseSealRequest outRequest) {
        String string = outRequest.getHorizontalText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (null == outRequest.getHorizontalTextFont()) {
            throw new SealSdkException("\u6ca1\u6709\u6307\u5b9a\u6a2a\u5411\u6587\u5b57\u4f53");
        }
    }

    private void validateTopSurroundText(EllipseSealRequest outRequest) {
        String string = outRequest.getTopSurroundText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (null == outRequest.getTopSurroundTextFont()) {
            throw new SealSdkException("\u6ca1\u6709\u6307\u5b9a\u9876\u90e8\u73af\u7ed5\u6587\u5b57\u4f53");
        }
    }

    private void validateCenterInfo(EllipseSealRequest outRequest) {
        CenterTypeEnum centerTypeEnum = outRequest.getCenterTypeEnum();
        if (CenterTypeEnum.NUMBER.equals((Object)centerTypeEnum)) {
            String string = outRequest.getCenterContent();
            if (StringUtils.isBlank(string)) {
                throw new SealSdkException("\u4e2d\u5fc3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == outRequest.getCenterContentFont()) {
                throw new SealSdkException("\u4e2d\u5fc3\u5185\u5bb9\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

