/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.OutputLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.util.Pack;

public class AESLightEngine
implements BlockCipher {
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private static final int m4 = -1061109568;
    private static final int m5 = 0x3F3F3F3F;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private boolean forEncryption;
    private static final int BLOCK_SIZE = 16;

    private static int shift(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }

    private static int FFmulX(int n2) {
        return (n2 & 0x7F7F7F7F) << 1 ^ ((n2 & 0x80808080) >>> 7) * 27;
    }

    private static int FFmulX2(int n2) {
        int n3 = (n2 & 0x3F3F3F3F) << 2;
        int n4 = n2 & 0xC0C0C0C0;
        n4 ^= n4 >>> 1;
        return n3 ^ n4 >>> 2 ^ n4 >>> 5;
    }

    private static int mcol(int n2) {
        int n3 = AESLightEngine.shift(n2, 8);
        int n4 = n2 ^ n3;
        return AESLightEngine.shift(n4, 16) ^ n3 ^ AESLightEngine.FFmulX(n4);
    }

    private static int inv_mcol(int n2) {
        int n3 = n2;
        int n4 = n3 ^ AESLightEngine.shift(n3, 8);
        n3 ^= AESLightEngine.FFmulX(n4);
        n4 ^= AESLightEngine.FFmulX2(n3);
        return n3 ^= n4 ^ AESLightEngine.shift(n4, 16);
    }

    private static int subWord(int n2) {
        return S[n2 & 0xFF] & 0xFF | (S[n2 >> 8 & 0xFF] & 0xFF) << 8 | (S[n2 >> 16 & 0xFF] & 0xFF) << 16 | S[n2 >> 24 & 0xFF] << 24;
    }

    private int[][] generateWorkingKey(byte[] byArray, boolean bl2) {
        int n2;
        int n3;
        int n4 = byArray.length;
        if (n4 < 16 || n4 > 32 || (n4 & 7) != 0) {
            throw new IllegalArgumentException("Key length not 128/192/256 bits.");
        }
        int n5 = n4 >> 2;
        this.ROUNDS = n5 + 6;
        int[][] nArray = new int[this.ROUNDS + 1][4];
        switch (n5) {
            case 4: {
                int n6;
                int n7;
                int n8;
                int n9;
                nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n9 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n8 = Pack.littleEndianToInt(byArray, 12);
                for (n7 = 1; n7 <= 10; ++n7) {
                    n6 = AESLightEngine.subWord(AESLightEngine.shift(n8, 8)) ^ rcon[n7 - 1];
                    nArray[n7][0] = n3 ^= n6;
                    nArray[n7][1] = n2 ^= n3;
                    nArray[n7][2] = n9 ^= n2;
                    nArray[n7][3] = n8 ^= n9;
                }
                break;
            }
            case 6: {
                int n10;
                int n6;
                int n7;
                int n8;
                int n9;
                nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n9 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n8 = Pack.littleEndianToInt(byArray, 12);
                nArray[1][0] = n7 = Pack.littleEndianToInt(byArray, 16);
                nArray[1][1] = n6 = Pack.littleEndianToInt(byArray, 20);
                int n11 = 1;
                int n12 = AESLightEngine.subWord(AESLightEngine.shift(n6, 8)) ^ n11;
                n11 <<= 1;
                nArray[1][2] = n3 ^= n12;
                nArray[1][3] = n2 ^= n3;
                nArray[2][0] = n9 ^= n2;
                nArray[2][1] = n8 ^= n9;
                nArray[2][2] = n7 ^= n8;
                nArray[2][3] = n6 ^= n7;
                for (n10 = 3; n10 < 12; n10 += 3) {
                    n12 = AESLightEngine.subWord(AESLightEngine.shift(n6, 8)) ^ n11;
                    n11 <<= 1;
                    nArray[n10][0] = n3 ^= n12;
                    nArray[n10][1] = n2 ^= n3;
                    nArray[n10][2] = n9 ^= n2;
                    nArray[n10][3] = n8 ^= n9;
                    nArray[n10 + 1][0] = n7 ^= n8;
                    nArray[n10 + 1][1] = n6 ^= n7;
                    n12 = AESLightEngine.subWord(AESLightEngine.shift(n6, 8)) ^ n11;
                    n11 <<= 1;
                    nArray[n10 + 1][2] = n3 ^= n12;
                    nArray[n10 + 1][3] = n2 ^= n3;
                    nArray[n10 + 2][0] = n9 ^= n2;
                    nArray[n10 + 2][1] = n8 ^= n9;
                    nArray[n10 + 2][2] = n7 ^= n8;
                    nArray[n10 + 2][3] = n6 ^= n7;
                }
                n12 = AESLightEngine.subWord(AESLightEngine.shift(n6, 8)) ^ n11;
                nArray[12][0] = n3 ^= n12;
                nArray[12][1] = n2 ^= n3;
                nArray[12][2] = n9 ^= n2;
                nArray[12][3] = n8 ^= n9;
                break;
            }
            case 8: {
                int n10;
                int n12;
                int n11;
                int n6;
                int n7;
                int n8;
                int n9;
                nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n9 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n8 = Pack.littleEndianToInt(byArray, 12);
                nArray[1][0] = n7 = Pack.littleEndianToInt(byArray, 16);
                nArray[1][1] = n6 = Pack.littleEndianToInt(byArray, 20);
                nArray[1][2] = n11 = Pack.littleEndianToInt(byArray, 24);
                nArray[1][3] = n12 = Pack.littleEndianToInt(byArray, 28);
                int n13 = 1;
                for (int i2 = 2; i2 < 14; i2 += 2) {
                    n10 = AESLightEngine.subWord(AESLightEngine.shift(n12, 8)) ^ n13;
                    n13 <<= 1;
                    nArray[i2][0] = n3 ^= n10;
                    nArray[i2][1] = n2 ^= n3;
                    nArray[i2][2] = n9 ^= n2;
                    nArray[i2][3] = n8 ^= n9;
                    n10 = AESLightEngine.subWord(n8);
                    nArray[i2 + 1][0] = n7 ^= n10;
                    nArray[i2 + 1][1] = n6 ^= n7;
                    nArray[i2 + 1][2] = n11 ^= n6;
                    nArray[i2 + 1][3] = n12 ^= n11;
                }
                n10 = AESLightEngine.subWord(AESLightEngine.shift(n12, 8)) ^ n13;
                nArray[14][0] = n3 ^= n10;
                nArray[14][1] = n2 ^= n3;
                nArray[14][2] = n9 ^= n2;
                nArray[14][3] = n8 ^= n9;
                break;
            }
            default: {
                throw new IllegalStateException("Should never get here");
            }
        }
        if (!bl2) {
            for (n3 = 1; n3 < this.ROUNDS; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    nArray[n3][n2] = AESLightEngine.inv_mcol(nArray[n3][n2]);
                }
            }
        }
        return nArray;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey(), bl2);
            this.forEncryption = bl2;
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + cipherParameters.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.WorkingKey == null) {
            throw new IllegalStateException("AES engine not initialised");
        }
        if (n2 + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 16 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            this.unpackBlock(byArray, n2);
            this.encryptBlock(this.WorkingKey);
            this.packBlock(byArray2, n3);
        } else {
            this.unpackBlock(byArray, n2);
            this.decryptBlock(this.WorkingKey);
            this.packBlock(byArray2, n3);
        }
        return 16;
    }

    @Override
    public void reset() {
    }

    private void unpackBlock(byte[] byArray, int n2) {
        int n3 = n2;
        this.C0 = byArray[n3++] & 0xFF;
        this.C0 |= (byArray[n3++] & 0xFF) << 8;
        this.C0 |= (byArray[n3++] & 0xFF) << 16;
        this.C0 |= byArray[n3++] << 24;
        this.C1 = byArray[n3++] & 0xFF;
        this.C1 |= (byArray[n3++] & 0xFF) << 8;
        this.C1 |= (byArray[n3++] & 0xFF) << 16;
        this.C1 |= byArray[n3++] << 24;
        this.C2 = byArray[n3++] & 0xFF;
        this.C2 |= (byArray[n3++] & 0xFF) << 8;
        this.C2 |= (byArray[n3++] & 0xFF) << 16;
        this.C2 |= byArray[n3++] << 24;
        this.C3 = byArray[n3++] & 0xFF;
        this.C3 |= (byArray[n3++] & 0xFF) << 8;
        this.C3 |= (byArray[n3++] & 0xFF) << 16;
        this.C3 |= byArray[n3++] << 24;
    }

    private void packBlock(byte[] byArray, int n2) {
        int n3 = n2;
        byArray[n3++] = (byte)this.C0;
        byArray[n3++] = (byte)(this.C0 >> 8);
        byArray[n3++] = (byte)(this.C0 >> 16);
        byArray[n3++] = (byte)(this.C0 >> 24);
        byArray[n3++] = (byte)this.C1;
        byArray[n3++] = (byte)(this.C1 >> 8);
        byArray[n3++] = (byte)(this.C1 >> 16);
        byArray[n3++] = (byte)(this.C1 >> 24);
        byArray[n3++] = (byte)this.C2;
        byArray[n3++] = (byte)(this.C2 >> 8);
        byArray[n3++] = (byte)(this.C2 >> 16);
        byArray[n3++] = (byte)(this.C2 >> 24);
        byArray[n3++] = (byte)this.C3;
        byArray[n3++] = (byte)(this.C3 >> 8);
        byArray[n3++] = (byte)(this.C3 >> 16);
        byArray[n3++] = (byte)(this.C3 >> 24);
    }

    private void encryptBlock(int[][] nArray) {
        int n2;
        int n3;
        int n4;
        int n5 = this.C0 ^ nArray[0][0];
        int n6 = this.C1 ^ nArray[0][1];
        int n7 = this.C2 ^ nArray[0][2];
        int n8 = 1;
        int n9 = this.C3 ^ nArray[0][3];
        while (n8 < this.ROUNDS - 1) {
            n4 = AESLightEngine.mcol(S[n5 & 0xFF] & 0xFF ^ (S[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n3 = AESLightEngine.mcol(S[n6 & 0xFF] & 0xFF ^ (S[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n2 = AESLightEngine.mcol(S[n7 & 0xFF] & 0xFF ^ (S[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            n9 = AESLightEngine.mcol(S[n9 & 0xFF] & 0xFF ^ (S[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n7 >> 24 & 0xFF] << 24) ^ nArray[n8++][3];
            n5 = AESLightEngine.mcol(S[n4 & 0xFF] & 0xFF ^ (S[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n6 = AESLightEngine.mcol(S[n3 & 0xFF] & 0xFF ^ (S[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n4 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n7 = AESLightEngine.mcol(S[n2 & 0xFF] & 0xFF ^ (S[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n3 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            n9 = AESLightEngine.mcol(S[n9 & 0xFF] & 0xFF ^ (S[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >> 24 & 0xFF] << 24) ^ nArray[n8++][3];
        }
        n4 = AESLightEngine.mcol(S[n5 & 0xFF] & 0xFF ^ (S[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
        n3 = AESLightEngine.mcol(S[n6 & 0xFF] & 0xFF ^ (S[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
        n2 = AESLightEngine.mcol(S[n7 & 0xFF] & 0xFF ^ (S[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
        n9 = AESLightEngine.mcol(S[n9 & 0xFF] & 0xFF ^ (S[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n7 >> 24 & 0xFF] << 24) ^ nArray[n8++][3];
        this.C0 = S[n4 & 0xFF] & 0xFF ^ (S[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n9 >> 24 & 0xFF] << 24 ^ nArray[n8][0];
        this.C1 = S[n3 & 0xFF] & 0xFF ^ (S[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n4 >> 24 & 0xFF] << 24 ^ nArray[n8][1];
        this.C2 = S[n2 & 0xFF] & 0xFF ^ (S[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n3 >> 24 & 0xFF] << 24 ^ nArray[n8][2];
        this.C3 = S[n9 & 0xFF] & 0xFF ^ (S[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >> 24 & 0xFF] << 24 ^ nArray[n8][3];
    }

    private void decryptBlock(int[][] nArray) {
        int n2;
        int n3;
        int n4;
        int n5 = this.C0 ^ nArray[this.ROUNDS][0];
        int n6 = this.C1 ^ nArray[this.ROUNDS][1];
        int n7 = this.C2 ^ nArray[this.ROUNDS][2];
        int n8 = this.ROUNDS - 1;
        int n9 = this.C3 ^ nArray[this.ROUNDS][3];
        while (n8 > 1) {
            n4 = AESLightEngine.inv_mcol(Si[n5 & 0xFF] & 0xFF ^ (Si[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n3 = AESLightEngine.inv_mcol(Si[n6 & 0xFF] & 0xFF ^ (Si[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n7 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n2 = AESLightEngine.inv_mcol(Si[n7 & 0xFF] & 0xFF ^ (Si[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            n9 = AESLightEngine.inv_mcol(Si[n9 & 0xFF] & 0xFF ^ (Si[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n5 >> 24 & 0xFF] << 24) ^ nArray[n8--][3];
            n5 = AESLightEngine.inv_mcol(Si[n4 & 0xFF] & 0xFF ^ (Si[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n3 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n6 = AESLightEngine.inv_mcol(Si[n3 & 0xFF] & 0xFF ^ (Si[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n2 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n7 = AESLightEngine.inv_mcol(Si[n2 & 0xFF] & 0xFF ^ (Si[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            n9 = AESLightEngine.inv_mcol(Si[n9 & 0xFF] & 0xFF ^ (Si[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n4 >> 24 & 0xFF] << 24) ^ nArray[n8--][3];
        }
        n4 = AESLightEngine.inv_mcol(Si[n5 & 0xFF] & 0xFF ^ (Si[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
        n3 = AESLightEngine.inv_mcol(Si[n6 & 0xFF] & 0xFF ^ (Si[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n7 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
        n2 = AESLightEngine.inv_mcol(Si[n7 & 0xFF] & 0xFF ^ (Si[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
        n9 = AESLightEngine.inv_mcol(Si[n9 & 0xFF] & 0xFF ^ (Si[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][3];
        this.C0 = Si[n4 & 0xFF] & 0xFF ^ (Si[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n3 >> 24 & 0xFF] << 24 ^ nArray[0][0];
        this.C1 = Si[n3 & 0xFF] & 0xFF ^ (Si[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n2 >> 24 & 0xFF] << 24 ^ nArray[0][1];
        this.C2 = Si[n2 & 0xFF] & 0xFF ^ (Si[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n9 >> 24 & 0xFF] << 24 ^ nArray[0][2];
        this.C3 = Si[n9 & 0xFF] & 0xFF ^ (Si[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n4 >> 24 & 0xFF] << 24 ^ nArray[0][3];
    }
}

