/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.e;
import com.timevale.tgtext.text.l;
import com.timevale.tgtext.text.m;
import com.timevale.tgtext.text.pdf.p;

public class Font
implements Comparable<Font> {
    public static final int Wv = 0;
    public static final int Ww = 1;
    public static final int Wx = 2;
    public static final int Wy = 4;
    public static final int Wz = 8;
    public static final int WA = 3;
    public static final int WB = -1;
    public static final int WC = 12;
    private FontFamily WD = FontFamily.UNDEFINED;
    private float WE = -1.0f;
    private int WF = -1;
    private e NP = null;
    private p Qq = null;

    public Font(Font other) {
        this.WD = other.WD;
        this.WE = other.WE;
        this.WF = other.WF;
        this.NP = other.NP;
        this.Qq = other.Qq;
    }

    public Font(FontFamily family, float size, int style, e color) {
        this.WD = family;
        this.WE = size;
        this.WF = style;
        this.NP = color;
    }

    public Font(p bf2, float size, int style, e color) {
        this.Qq = bf2;
        this.WE = size;
        this.WF = style;
        this.NP = color;
    }

    public Font(p bf2, float size, int style) {
        this(bf2, size, style, null);
    }

    public Font(p bf2, float size) {
        this(bf2, size, -1, null);
    }

    public Font(p bf2) {
        this(bf2, -1.0f, -1, null);
    }

    public Font(FontFamily family, float size, int style) {
        this(family, size, style, null);
    }

    public Font(FontFamily family, float size) {
        this(family, size, -1, null);
    }

    public Font(FontFamily family) {
        this(family, -1.0f, -1, null);
    }

    public Font() {
        this(FontFamily.UNDEFINED, -1.0f, -1, null);
    }

    public int b(Font font) {
        if (font == null) {
            return -1;
        }
        try {
            if (this.Qq != null && !this.Qq.equals(font.BF())) {
                return -2;
            }
            if (this.WD != font.Bv()) {
                return 1;
            }
            if (this.WE != font.Bx()) {
                return 2;
            }
            if (this.WF != font.Bz()) {
                return 3;
            }
            if (this.NP == null) {
                if (font.NP == null) {
                    return 0;
                }
                return 4;
            }
            if (font.NP == null) {
                return 4;
            }
            if (this.NP.equals(font.xz())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -3;
        }
    }

    public FontFamily Bv() {
        return this.WD;
    }

    public String Bw() {
        String string = "unknown";
        switch (this.Bv()) {
            case COURIER: {
                return "Courier";
            }
            case HELVETICA: {
                return "Helvetica";
            }
            case TIMES_ROMAN: {
                return "Times-Roman";
            }
            case SYMBOL: {
                return "Symbol";
            }
            case ZAPFDINGBATS: {
                return "ZapfDingbats";
            }
        }
        if (this.Qq != null) {
            String[][] stringArray;
            for (String[] stringArray2 : stringArray = this.Qq.Gn()) {
                if ("0".equals(stringArray2[2])) {
                    return stringArray2[3];
                }
                if ("1033".equals(stringArray2[2])) {
                    string = stringArray2[3];
                }
                if (!"".equals(stringArray2[2])) continue;
                string = stringArray2[3];
            }
        }
        return string;
    }

    public void fn(String string) {
        this.WD = Font.fo(string);
    }

    public static FontFamily fo(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return FontFamily.COURIER;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return FontFamily.HELVETICA;
        }
        if (string.equalsIgnoreCase("Times-Roman")) {
            return FontFamily.TIMES_ROMAN;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return FontFamily.SYMBOL;
        }
        if (string.equalsIgnoreCase("ZapfDingbats")) {
            return FontFamily.ZAPFDINGBATS;
        }
        return FontFamily.UNDEFINED;
    }

    public float Bx() {
        return this.WE;
    }

    public float By() {
        float f2 = this.WE;
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        return f2;
    }

    public float F(float f2) {
        return f2 * this.By();
    }

    public void G(float f2) {
        this.WE = f2;
    }

    public int Bz() {
        return this.WF;
    }

    public int BA() {
        int n2 = this.WF;
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.Qq != null) {
            return n2;
        }
        if (this.WD == FontFamily.SYMBOL || this.WD == FontFamily.ZAPFDINGBATS) {
            return n2;
        }
        return n2 & 0xFFFFFFFC;
    }

    public boolean BB() {
        if (this.WF == -1) {
            return false;
        }
        return (this.WF & 1) == 1;
    }

    public boolean BC() {
        if (this.WF == -1) {
            return false;
        }
        return (this.WF & 2) == 2;
    }

    public boolean BD() {
        if (this.WF == -1) {
            return false;
        }
        return (this.WF & 4) == 4;
    }

    public boolean BE() {
        if (this.WF == -1) {
            return false;
        }
        return (this.WF & 8) == 8;
    }

    public void dz(int n2) {
        this.WF = n2;
    }

    public void fp(String string) {
        if (this.WF == -1) {
            this.WF = 0;
        }
        this.WF |= Font.fq(string);
    }

    public static int fq(String string) {
        int n2 = 0;
        if (string.indexOf(FontStyle.NORMAL.getValue()) != -1) {
            n2 |= 0;
        }
        if (string.indexOf(FontStyle.BOLD.getValue()) != -1) {
            n2 |= 1;
        }
        if (string.indexOf(FontStyle.ITALIC.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.OBLIQUE.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.UNDERLINE.getValue()) != -1) {
            n2 |= 4;
        }
        if (string.indexOf(FontStyle.LINETHROUGH.getValue()) != -1) {
            n2 |= 8;
        }
        return n2;
    }

    public e xz() {
        return this.NP;
    }

    public void a(e e2) {
        this.NP = e2;
    }

    public void z(int n2, int n3, int n4) {
        this.NP = new e(n2, n3, n4);
    }

    public p BF() {
        return this.Qq;
    }

    public p ac(boolean bl2) {
        if (this.Qq != null) {
            return this.Qq;
        }
        int n2 = this.WF;
        if (n2 == -1) {
            n2 = 0;
        }
        String string = "Helvetica";
        String string2 = "Cp1252";
        p p2 = null;
        block1 : switch (this.WD) {
            case COURIER: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Courier-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Courier-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Courier-BoldOblique";
                        break block1;
                    }
                }
                string = "Courier";
                break;
            }
            case TIMES_ROMAN: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Times-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Times-Italic";
                        break block1;
                    }
                    case 3: {
                        string = "Times-BoldItalic";
                        break block1;
                    }
                }
                string = "Times-Roman";
                break;
            }
            case SYMBOL: {
                string = "Symbol";
                if (!bl2) break;
                string2 = "Symbol";
                break;
            }
            case ZAPFDINGBATS: {
                string = "ZapfDingbats";
                if (!bl2) break;
                string2 = "ZapfDingbats";
                break;
            }
            default: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Helvetica-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Helvetica-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Helvetica-BoldOblique";
                        break block1;
                    }
                }
                string = "Helvetica";
            }
        }
        try {
            p2 = p.c(string, string2, false);
        }
        catch (Exception exception) {
            throw new l(exception);
        }
        return p2;
    }

    public boolean BG() {
        return this.WD == FontFamily.UNDEFINED && this.WE == -1.0f && this.WF == -1 && this.NP == null && this.Qq == null;
    }

    public Font c(Font font) {
        e e2;
        if (font == null) {
            return this;
        }
        float f2 = font.WE;
        if (f2 == -1.0f) {
            f2 = this.WE;
        }
        int n2 = -1;
        int n3 = this.WF;
        int n4 = font.Bz();
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            n2 = n3 | n4;
        }
        if ((e2 = font.NP) == null) {
            e2 = this.NP;
        }
        if (font.Qq != null) {
            return new Font(font.Qq, f2, n2, e2);
        }
        if (font.Bv() != FontFamily.UNDEFINED) {
            return new Font(font.WD, f2, n2, e2);
        }
        if (this.Qq != null) {
            if (n2 == n3) {
                return new Font(this.Qq, f2, n2, e2);
            }
            return m.a(this.Bw(), f2, n2, e2);
        }
        return new Font(this.WD, f2, n2, e2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.b((Font)object);
    }

    public static enum FontStyle {
        NORMAL("normal"),
        BOLD("bold"),
        ITALIC("italic"),
        OBLIQUE("oblique"),
        UNDERLINE("underline"),
        LINETHROUGH("line-through");

        private String code;

        private FontStyle(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.code;
        }
    }

    public static enum FontFamily {
        COURIER,
        HELVETICA,
        TIMES_ROMAN,
        SYMBOL,
        ZAPFDINGBATS,
        UNDEFINED;

    }
}

