/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abz;
    protected Alignment abA = Alignment.LEFT;
    protected DrawInterface abB;
    protected char abC = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abz = position;
        this.abB = leader;
        this.abA = alignment;
        this.abC = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.Eq(), tabStop.Es(), tabStop.Er(), tabStop.Et());
    }

    public float Eq() {
        return this.abz;
    }

    public void an(float f2) {
        this.abz = f2;
    }

    public Alignment Er() {
        return this.abA;
    }

    public void a(Alignment alignment) {
        this.abA = alignment;
    }

    public DrawInterface Es() {
        return this.abB;
    }

    public void a(DrawInterface drawInterface) {
        this.abB = drawInterface;
    }

    public char Et() {
        return this.abC;
    }

    public void k(char c2) {
        this.abC = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abz;
        float f6 = f3 - f2;
        switch (this.abA) {
            case RIGHT: {
                if (f2 + f6 < this.abz) {
                    f5 = this.abz - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abz) {
                    f5 = this.abz - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abz) {
                        f5 = this.abz - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abz ? this.abz - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

