/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.network.impl.http;

import esign.utils.IOUtil;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import esign.utils.httpclient.HttpConfigT;
import esign.utils.httppool.HttpPool;
import esign.utils.network.NtmExecutor;
import esign.utils.network.NtmResponse;
import esign.utils.network.request.NtmHttpRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNtmHttpExecutor<T, RT extends HttpUriRequest>
implements NtmExecutor<T> {
    protected RT request;
    protected HttpConfigT<T> httpConfigT;
    private static HttpPool defaultGlobalPool = new HttpPool(10, 2);
    private static final Logger LOGGER = LoggerFactory.getLogger(NtmHttpRequest.class);

    protected AbstractNtmHttpExecutor(RT request, HttpConfigT<T> httpConfigT) {
        if (null != httpConfigT.getHeaderMgmt()) {
            httpConfigT.getHeaderMgmt().installHeaders((HttpMessage)request);
        }
        this.request = request;
        this.httpConfigT = httpConfigT;
    }

    @Override
    public NtmResponse<T> execute() throws SuperException {
        return this.run((HttpUriRequest)this.request, this.httpConfigT);
    }

    protected NtmResponse<T> run(HttpUriRequest req, HttpConfigT<T> config) throws SuperException {
        final RawNtmHttpResponse rawNtmHttpResponse = this.rawRun(req, config);
        final T t2 = config.parse(rawNtmHttpResponse.code, rawNtmHttpResponse.data, config.getEncoding());
        return new NtmResponse<T>(){

            @Override
            public T getResult() {
                return t2;
            }

            @Override
            public int getCode() {
                return rawNtmHttpResponse.code;
            }

            @Override
            public boolean success() {
                return AbstractNtmHttpExecutor.this.httpStatusIsOk(rawNtmHttpResponse.code);
            }
        };
    }

    private synchronized HttpPool getConnectionPool(HttpConfig config) {
        if (null != config.getHttpPool()) {
            return config.getHttpPool();
        }
        return defaultGlobalPool;
    }

    private RawNtmHttpResponse rawRun(HttpUriRequest req, HttpConfig config) throws SuperException {
        CloseableHttpClient closeableHttpClient = null;
        InputStream inputStream = null;
        long l2 = System.currentTimeMillis();
        try {
            closeableHttpClient = this.getConnectionPool(config).client(config);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(req);
            inputStream = this.getNetworkStream((HttpResponse)closeableHttpResponse);
            int n2 = this.checkResponse(req, (HttpResponse)closeableHttpResponse);
            byte[] byArray = this.response(inputStream);
            if (null != config.getResponseReady()) {
                config.getResponseReady().ready((HttpResponse)closeableHttpResponse, byArray);
            }
            RawNtmHttpResponse rawNtmHttpResponse = new RawNtmHttpResponse(n2, byArray);
            return rawNtmHttpResponse;
        }
        catch (SuperException superException) {
            LOGGER.error("http to url failed. url:{}", (Object)req.getURI().toString());
            LOGGER.error("http client execute failed.", (Throwable)superException);
            throw superException;
        }
        catch (Exception exception) {
            LOGGER.error("http to url failed. url:{}", (Object)req.getURI().toString());
            LOGGER.error("http client execute failed.", (Throwable)exception);
            throw ErrorsDiscriptor.ExternalService.e(exception);
        }
        finally {
            LOGGER.info("request execute finished. url:{}, cost:{}", (Object)req.getURI(), (Object)(System.currentTimeMillis() - l2));
            this.close(closeableHttpClient, inputStream);
        }
    }

    private void close(CloseableHttpClient cli, InputStream stm) throws SuperException {
        if (null != stm) {
            try {
                stm.close();
            }
            catch (IOException iOException) {
                LOGGER.error("stream close failed and then close the connection.", (Throwable)iOException);
            }
        }
    }

    private byte[] response(InputStream stream) throws SuperException {
        try {
            return IOUtil.readStreamAsByteArray(stream);
        }
        catch (IOException iOException) {
            LOGGER.error("read data from response stream failed.", (Throwable)iOException);
            throw ErrorsDiscriptor.ExternalService.e(iOException);
        }
    }

    private int checkResponse(HttpUriRequest req, HttpResponse resp) throws SuperException {
        AssertSupport.assertNotnull(resp, ErrorsDiscriptor.InternalServiceTaken.e("null response"));
        AssertSupport.assertNotnull(resp.getStatusLine(), ErrorsDiscriptor.InternalServiceTaken.e("null response status line"));
        int n2 = resp.getStatusLine().getStatusCode();
        LOGGER.debug("receive http response. code:{}", (Object)n2);
        if (this.httpStatusIsOk(n2)) {
            return n2;
        }
        LOGGER.warn("http execute failed. uri:{}, code:{}", (Object)req.getURI().toString(), (Object)n2);
        return n2;
    }

    private boolean httpStatusIsOk(int code) {
        return code >= 200 && code < 300;
    }

    private InputStream getNetworkStream(HttpResponse resp) throws SuperException {
        try {
            if (null == resp.getEntity()) {
                LOGGER.error("there is no json data in body.");
                throw ErrorsDiscriptor.ExternalService.e();
            }
            return resp.getEntity().getContent();
        }
        catch (Exception exception) {
            LOGGER.error("http execute failed.", (Throwable)exception);
            throw ErrorsDiscriptor.ExternalService.e(exception);
        }
    }

    private static class RawNtmHttpResponse {
        private int code;
        private byte[] data;

        private RawNtmHttpResponse(int code, byte[] data) {
            this.code = code;
            this.data = data;
        }
    }
}

