/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.bean.httpvo.FileUploadUrlResult;
import com.timevale.esign.paas.tech.bean.model.CreateEviModel;
import com.timevale.esign.paas.tech.bean.model.QueryEviModel;
import com.timevale.esign.paas.tech.bean.request.CreateEviParam;
import com.timevale.esign.paas.tech.bean.result.CreateEviResult;
import com.timevale.esign.paas.tech.bean.result.QueryEviResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.common.FileSystemHelper;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.service.EviService;
import com.timevale.esign.paas.tech.service.a.a;
import com.timevale.seal.sdk.util.StringUtils;
import com.timevale.tech.sdk.utils.MD5Util;
import esign.utils.JsonHelper;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.SuperException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class f
extends a
implements EviService {
    private static final Logger log = LoggerFactory.getLogger(f.class);

    public f() {
    }

    public f(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public CreateEviResult createEvi(CreateEviParam param) {
        try {
            String[] stringArray;
            param.check();
            String string = null;
            if (StringUtils.isNotBlank(param.getFileName())) {
                string = param.getFileName();
            }
            if (StringUtils.isBlank(string) && (param.getStreamFile() == null || param.getStreamFile().length == 0)) {
                stringArray = param.getSrcPdfFile().split("/");
                string = stringArray[stringArray.length - 1];
            }
            if (StringUtils.isBlank(string)) {
                string = "stream.pdf";
            }
            stringArray = MD5Util.md5(param.getBytes());
            FileUploadUrlResult fileUploadUrlResult = FileSystemHelper.getUploadUrl(this.uy(), (String)stringArray, string);
            if (StringUtils.isBlank(fileUploadUrlResult.getFileKey()) || StringUtils.isBlank(fileUploadUrlResult.getUrl())) {
                throw ErrorException.FILE_UPLOAD_ERROR.e();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Content-MD5", (String)stringArray);
            hashMap.put("Content-Type", "application/octet-stream");
            FileSystemHelper.upload(fileUploadUrlResult.getUrl(), param.getBytes(), hashMap);
            CreateEviModel createEviModel = (CreateEviModel)this.uy().getContext().a(InterfaceKey.CREATE_EVI);
            createEviModel.setFileId(fileUploadUrlResult.getFileKey());
            createEviModel.setNotifyUrl(param.getNotifyUrl());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), createEviModel);
            return JsonHelper.fromJson(jsonObject, CreateEviResult.class);
        }
        catch (SuperException superException) {
            log.warn("createEvi fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, CreateEviResult.class);
        }
        catch (Exception exception) {
            log.warn("createEvi Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_EVI_ERROR.e(exception.getMessage()), CreateEviResult.class);
        }
    }

    @Override
    public QueryEviResult queryEviResult(String evId) {
        try {
            if (StringUtils.isBlank(evId)) {
                throw ErrorException.QUERY_EVI_ERROR.e("evId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            QueryEviModel queryEviModel = (QueryEviModel)this.uy().getContext().a(InterfaceKey.QUERY_EVI);
            queryEviModel.setEvId(evId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), queryEviModel);
            return JsonHelper.fromJson(jsonObject, QueryEviResult.class);
        }
        catch (SuperException superException) {
            log.warn("queryEviResult fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, QueryEviResult.class);
        }
        catch (Exception exception) {
            log.warn("queryEviResult Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.QUERY_EVI_ERROR.e(exception.getMessage()), QueryEviResult.class);
        }
    }
}

