/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a2, @Nullable Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static String simpleName(Class<?> clazz) {
        String string = clazz.getName();
        int n2 = (string = string.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (n2 == -1) {
            n2 = string.lastIndexOf(46);
        }
        return string.substring(n2 + 1);
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    public static final class ToStringHelper {
        private final StringBuilder builder;
        private boolean needsSeparator = false;

        private ToStringHelper(String className) {
            Preconditions.checkNotNull(className);
            this.builder = new StringBuilder(32).append(className).append('{');
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            Preconditions.checkNotNull(name);
            this.maybeAppendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                String string = this.builder.append('}').toString();
                return string;
            }
            finally {
                this.builder.setLength(this.builder.length() - 1);
            }
        }

        private StringBuilder maybeAppendSeparator() {
            if (this.needsSeparator) {
                return this.builder.append(", ");
            }
            this.needsSeparator = true;
            return this.builder;
        }
    }
}

