/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BstSide;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible
class BstNode<K, N extends BstNode<K, N>> {
    private final K key;
    @Nullable
    private final N left;
    @Nullable
    private final N right;

    BstNode(K key, @Nullable N left, @Nullable N right) {
        this.key = Preconditions.checkNotNull(key);
        this.left = left;
        this.right = right;
    }

    public final K getKey() {
        return this.key;
    }

    @Nullable
    public final N childOrNull(BstSide side) {
        switch (side) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasChild(BstSide side) {
        return this.childOrNull(side) != null;
    }

    public final N getChild(BstSide side) {
        N n2 = this.childOrNull(side);
        Preconditions.checkState(n2 != null);
        return n2;
    }

    protected final boolean orderingInvariantHolds(Comparator<? super K> comparator) {
        Preconditions.checkNotNull(comparator);
        boolean bl2 = true;
        if (this.hasChild(BstSide.LEFT)) {
            bl2 &= comparator.compare(((BstNode)this.getChild(BstSide.LEFT)).getKey(), this.key) < 0;
        }
        if (this.hasChild(BstSide.RIGHT)) {
            bl2 &= comparator.compare(((BstNode)this.getChild(BstSide.RIGHT)).getKey(), this.key) > 0;
        }
        return bl2;
    }
}

