/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.net;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.net.HostAndPort;
import com.timevale.guava.common.net.InetAddresses;
import com.timevale.guava.common.net.InternetDomainName;
import java.net.InetAddress;
import java.text.ParseException;
import javax.annotation.Nullable;

@Beta
public final class HostSpecifier {
    private final String canonicalForm;

    private HostSpecifier(String canonicalForm) {
        this.canonicalForm = canonicalForm;
    }

    public static HostSpecifier fromValid(String specifier) {
        HostAndPort hostAndPort = HostAndPort.fromString(specifier);
        Preconditions.checkArgument(!hostAndPort.hasPort());
        String string = hostAndPort.getHostText();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (inetAddress != null) {
            return new HostSpecifier(InetAddresses.toUriString(inetAddress));
        }
        InternetDomainName internetDomainName = InternetDomainName.from(string);
        if (internetDomainName.hasPublicSuffix()) {
            return new HostSpecifier(internetDomainName.name());
        }
        throw new IllegalArgumentException("Domain name does not have a recognized public suffix: " + string);
    }

    public static HostSpecifier from(String specifier) throws ParseException {
        try {
            return HostSpecifier.fromValid(specifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ParseException parseException = new ParseException("Invalid host specifier: " + specifier, 0);
            parseException.initCause(illegalArgumentException);
            throw parseException;
        }
    }

    public static boolean isValid(String specifier) {
        try {
            HostSpecifier.fromValid(specifier);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostSpecifier) {
            HostSpecifier hostSpecifier = (HostSpecifier)other;
            return this.canonicalForm.equals(hostSpecifier.canonicalForm);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public String toString() {
        return this.canonicalForm;
    }
}

