/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.util;

import com.timevale.seal.sdk.enums.FontLoader;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.request.LineWrapSealRequest;
import com.timevale.seal.sdk.response.SealImageResponse;
import com.timevale.seal.sdk.util.FontUtil;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import sun.font.FontDesignMetrics;

public class LineWrapSealUtil {
    public static SealImageResponse createLineWrapSeal(LineWrapSealRequest request) {
        LineWrapSealUtil.validateRequest(request);
        BufferedImage bufferedImage = LineWrapSealUtil.createLongBreakSeal(request.getText().trim().split("\\s+"), request.getFontSize(), request.getSealColor().getColor());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            SealImageResponse sealImageResponse = new SealImageResponse();
            sealImageResponse.setBytes(byteArrayOutputStream.toByteArray());
            sealImageResponse.setWidth(bufferedImage.getWidth());
            sealImageResponse.setHeight(bufferedImage.getHeight());
            return sealImageResponse;
        }
        catch (IOException iOException) {
            throw new SealSdkException("\u56fe\u7247\u8f6c\u5b57\u8282\u6d41\u5931\u8d25", iOException);
        }
    }

    private static void validateRequest(LineWrapSealRequest request) {
        if (request == null) {
            throw new SealSdkException("LineWrapSealRequest request is null");
        }
        if (StringUtils.isBlank(request.getText())) {
            throw new SealSdkException("LineWrapSealRequest text is null");
        }
        if (request.getFontSize() <= 0) {
            throw new SealSdkException("LineWrapSealRequest fontSize should > 0");
        }
    }

    private static BufferedImage createLongBreakSeal(String[] text, int fontSize, Color color) {
        int n2;
        Font font = LineWrapSealUtil.creatFont(FontLoader.SIMSUN.getFontName(), fontSize);
        int n3 = LineWrapSealUtil.getHeight(font);
        int n4 = n3 * text.length;
        int n5 = n4 > (n2 = LineWrapSealUtil.getWidth(font, LineWrapSealUtil.longestString(text))) ? n4 - n2 : 0;
        BufferedImage bufferedImage = new BufferedImage(n2 + n5, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        LineWrapSealUtil.drawStrings(graphics2D, text, n5, n3);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static void drawStrings(Graphics2D g2d, String[] text, int adaptWidth, int heightPerText) {
        int n2 = g2d.getFontMetrics().getAscent();
        adaptWidth /= 2;
        for (int i2 = 0; i2 < text.length; ++i2) {
            g2d.drawString(text[i2], adaptWidth, n2 + heightPerText * i2);
        }
    }

    private static int getHeight(Font font) {
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font);
        return fontDesignMetrics.getHeight();
    }

    private static int getWidth(Font font, String str) {
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font);
        return fontDesignMetrics.stringWidth(str);
    }

    private static String longestString(String[] text) {
        String string = text[0];
        for (int i2 = 1; i2 < text.length; ++i2) {
            if (text[i2].length() <= string.length()) continue;
            string = text[i2];
        }
        return string;
    }

    private static Font creatFont(String artType, int fontSize) {
        return FontUtil.processFont(FontUtil.loadFont(FontLoader.from(artType).getFontName()), 1, fontSize);
    }
}

