/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import com.timevale.tgtext.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.timevale.tgtext.bouncycastle.crypto.agreement.srp.SRP6Server;
import com.timevale.tgtext.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.SRP6GroupParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.AbstractTlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.DefaultTlsSRPGroupVerifier;
import com.timevale.tgtext.bouncycastle.crypto.tls.DigestInputBuffer;
import com.timevale.tgtext.bouncycastle.crypto.tls.DigitallySigned;
import com.timevale.tgtext.bouncycastle.crypto.tls.SecurityParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.ServerSRPParams;
import com.timevale.tgtext.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.timevale.tgtext.bouncycastle.crypto.tls.SignerInputBuffer;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsDSSSigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsRSASigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.crypto.util.PublicKeyFactory;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import com.timevale.tgtext.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected SRP6GroupParameters srpGroup = null;
    protected SRP6Client srpClient = null;
    protected SRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;
    protected BigInteger srpVerifier = null;
    protected byte[] srpSalt = null;
    protected TlsSignerCredentials serverCredentials = null;

    protected static TlsSigner createSigner(int n2) {
        switch (n2) {
            case 21: {
                return null;
            }
            case 23: {
                return new TlsRSASigner();
            }
            case 22: {
                return new TlsDSSSigner();
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int n2, Vector vector, byte[] byArray, byte[] byArray2) {
        this(n2, vector, new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public TlsSRPKeyExchange(int n2, Vector vector, TlsSRPGroupVerifier tlsSRPGroupVerifier, byte[] byArray, byte[] byArray2) {
        super(n2, vector);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(n2);
        this.groupVerifier = tlsSRPGroupVerifier;
        this.identity = byArray;
        this.password = byArray2;
        this.srpClient = new SRP6Client();
    }

    public TlsSRPKeyExchange(int n2, Vector vector, byte[] byArray, TlsSRPLoginParameters tlsSRPLoginParameters) {
        super(n2, vector);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(n2);
        this.identity = byArray;
        this.srpServer = new SRP6Server();
        this.srpGroup = tlsSRPLoginParameters.getGroup();
        this.srpVerifier = tlsSRPLoginParameters.getVerifier();
        this.srpSalt = tlsSRPLoginParameters.getSalt();
    }

    @Override
    public void init(TlsContext tlsContext) {
        super.init(tlsContext);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(tlsContext);
        }
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate certificate2 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate2.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(certificate2, 128);
        super.processServerCertificate(certificate);
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 21 || !(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        this.srpServer.init(this.srpGroup, this.srpVerifier, TlsUtils.createHash((short)2), this.context.getSecureRandom());
        BigInteger bigInteger = this.srpServer.generateServerCredentials();
        ServerSRPParams serverSRPParams = new ServerSRPParams(this.srpGroup.getN(), this.srpGroup.getG(), this.srpSalt, bigInteger);
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        serverSRPParams.encode(digestInputBuffer);
        if (this.serverCredentials != null) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
            Digest digest = TlsUtils.createHash(signatureAndHashAlgorithm);
            SecurityParameters securityParameters = this.context.getSecurityParameters();
            digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
            digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
            digestInputBuffer.updateDigest(digest);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
            DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
            digitallySigned.encode(digestInputBuffer);
        }
        return digestInputBuffer.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer signerInputBuffer = null;
        InputStream inputStream2 = inputStream;
        if (this.tlsSigner != null) {
            signerInputBuffer = new SignerInputBuffer();
            inputStream2 = new TeeInputStream(inputStream, signerInputBuffer);
        }
        ServerSRPParams serverSRPParams = ServerSRPParams.parse(inputStream2);
        if (signerInputBuffer != null) {
            DigitallySigned digitallySigned = this.parseSignature(inputStream);
            Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
            signerInputBuffer.updateSigner(signer);
            if (!signer.verifySignature(digitallySigned.getSignature())) {
                throw new TlsFatalAlert(51);
            }
        }
        this.srpGroup = new SRP6GroupParameters(serverSRPParams.getN(), serverSRPParams.getG());
        if (!this.groupVerifier.accept(this.srpGroup)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = serverSRPParams.getS();
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), serverSRPParams.getB());
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47, (Throwable)cryptoException);
        }
        this.srpClient.init(this.srpGroup, TlsUtils.createHash((short)2), this.context.getSecureRandom());
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        BigInteger bigInteger = this.srpClient.generateClientCredentials(this.srpSalt, this.identity, this.password);
        TlsSRPUtils.writeSRPParameter(bigInteger, outputStream);
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), TlsSRPUtils.readSRPParameter(inputStream));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47, (Throwable)cryptoException);
        }
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        try {
            BigInteger bigInteger = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
            return BigIntegers.asUnsignedByteArray(bigInteger);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47, (Throwable)cryptoException);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

