/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.timevale.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.SingleResp;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import com.timevale.tgtext.text.log.Logger;
import com.timevale.tgtext.text.log.b;
import com.timevale.tgtext.text.pdf.security.ab;
import com.timevale.tgtext.text.pdf.security.ac;
import com.timevale.tgtext.text.pdf.security.f;
import com.timevale.tgtext.text.pdf.security.q;
import com.timevale.tgtext.text.pdf.security.w;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public class p
extends w {
    protected static final Logger Pm = b.getLogger(p.class);
    protected List<BasicOCSPResp> buS;

    public p(f f2, List<BasicOCSPResp> list) {
        super(f2);
        this.buS = list;
    }

    @Override
    public List<ac> a(X509Certificate x509Certificate, X509Certificate x509Certificate2, Date date) throws GeneralSecurityException, IOException {
        ArrayList<ac> arrayList = new ArrayList<ac>();
        int n2 = 0;
        if (this.buS != null) {
            for (BasicOCSPResp basicOCSPResp : this.buS) {
                if (!this.a(basicOCSPResp, x509Certificate, x509Certificate2, date)) continue;
                ++n2;
            }
        }
        boolean bl2 = false;
        if (this.buK && n2 == 0 && this.a(this.b(x509Certificate, x509Certificate2), x509Certificate, x509Certificate2, date)) {
            ++n2;
            bl2 = true;
        }
        Pm.info("Valid OCSPs found: " + n2);
        if (n2 > 0) {
            arrayList.add(new ac(x509Certificate, this.getClass(), "Valid OCSPs Found: " + n2 + (bl2 ? " (online)" : "")));
        }
        if (this.buJ != null) {
            arrayList.addAll(this.buJ.a(x509Certificate, x509Certificate2, date));
        }
        return arrayList;
    }

    public boolean a(BasicOCSPResp basicOCSPResp, X509Certificate x509Certificate, X509Certificate x509Certificate2, Date date) throws GeneralSecurityException, IOException {
        if (basicOCSPResp == null) {
            return false;
        }
        SingleResp[] singleRespArray = basicOCSPResp.getResponses();
        for (int i2 = 0; i2 < singleRespArray.length; ++i2) {
            if (!x509Certificate.getSerialNumber().equals(singleRespArray[i2].getCertID().getSerialNumber())) continue;
            try {
                if (x509Certificate2 == null) {
                    x509Certificate2 = x509Certificate;
                }
                if (!singleRespArray[i2].getCertID().matchesIssuer(new X509CertificateHolder(x509Certificate2.getEncoded()), new BcDigestCalculatorProvider())) {
                    Pm.info("OCSP: Issuers doesn't match.");
                }
            }
            catch (OCSPException oCSPException) {}
            continue;
            Date date2 = singleRespArray[i2].getNextUpdate();
            if (date2 == null) {
                date2 = new Date(singleRespArray[i2].getThisUpdate().getTime() + 180000L);
                Pm.info(String.format("No 'next update' for OCSP Response; assuming %s", date2));
            }
            if (date.after(date2)) {
                Pm.info(String.format("OCSP no longer valid: %s after %s", date, date2));
                continue;
            }
            CertificateStatus certificateStatus = singleRespArray[i2].getCertStatus();
            if (certificateStatus != CertificateStatus.GOOD) continue;
            this.a(basicOCSPResp, x509Certificate2);
            return true;
        }
        return false;
    }

    public void a(BasicOCSPResp basicOCSPResp, X509Certificate x509Certificate) throws GeneralSecurityException, IOException {
        X509Certificate x509Certificate2;
        block4: {
            x509Certificate2 = x509Certificate;
            X509CertificateHolder[] x509CertificateHolderArray = basicOCSPResp.getCerts();
            if (x509CertificateHolderArray.length > 0) {
                x509Certificate2 = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolderArray[0]);
                try {
                    x509Certificate2.verify(x509Certificate.getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (super.a(x509Certificate2, x509Certificate, null).size() != 0) break block4;
                    throw new ab(x509Certificate2, "Responder certificate couldn't be verified");
                }
            }
        }
        if (!this.b(basicOCSPResp, x509Certificate2)) {
            throw new ab(x509Certificate2, "OCSP response could not be verified");
        }
    }

    public boolean b(BasicOCSPResp basicOCSPResp, X509Certificate x509Certificate) {
        if (this.a(basicOCSPResp, (Certificate)x509Certificate)) {
            return true;
        }
        if (this.bvB == null) {
            return false;
        }
        try {
            Enumeration<String> enumeration = this.bvB.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                try {
                    X509Certificate x509Certificate2;
                    if (!this.bvB.isCertificateEntry(string) || !this.a(basicOCSPResp, (Certificate)(x509Certificate2 = (X509Certificate)this.bvB.getCertificate(string)))) continue;
                    return true;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
        return false;
    }

    public boolean a(BasicOCSPResp basicOCSPResp, Certificate certificate) {
        try {
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(certificate.getPublicKey());
            return basicOCSPResp.isSignatureValid(contentVerifierProvider);
        }
        catch (OperatorCreationException operatorCreationException) {
            return false;
        }
        catch (OCSPException oCSPException) {
            return false;
        }
    }

    public BasicOCSPResp b(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (x509Certificate == null && x509Certificate2 == null) {
            return null;
        }
        q q2 = new q();
        BasicOCSPResp basicOCSPResp = q2.b(x509Certificate, x509Certificate2, null);
        if (basicOCSPResp == null) {
            return null;
        }
        SingleResp[] singleRespArray = basicOCSPResp.getResponses();
        for (int i2 = 0; i2 < singleRespArray.length; ++i2) {
            CertificateStatus certificateStatus = singleRespArray[i2].getCertStatus();
            if (certificateStatus != CertificateStatus.GOOD) continue;
            return basicOCSPResp;
        }
        return null;
    }
}

