/*
 * Decompiled with CFR 0.152.
 */
package esign.utils;

import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class ConfigProperties {
    private PropertiesConfiguration propertiesConfig;

    public ConfigProperties(String fileName) {
        try {
            this.propertiesConfig = new PropertiesConfiguration(fileName);
            this.propertiesConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
    }

    public String getString(String key) {
        return this.propertiesConfig.getString(key);
    }

    public List<?> getList(String key) {
        return this.propertiesConfig.getList(key);
    }

    public boolean getBoolean(String key) {
        return this.propertiesConfig.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.propertiesConfig.getBoolean(key, defaultValue);
    }

    public int getInt(String key) {
        return this.propertiesConfig.getInt(key);
    }

    public void setProperty(String key, Object value) throws ConfigurationException {
        if (this.propertiesConfig.containsKey(key)) {
            this.propertiesConfig.setProperty(key, value);
        } else {
            this.propertiesConfig.addProperty(key, value);
        }
        this.propertiesConfig.save();
        this.propertiesConfig.reload();
    }

    public String getListString(String key) {
        List<?> list = this.getList(key);
        String string = "";
        for (Object obj : list) {
            string = string + (String)obj;
            string = string + ",";
        }
        int n2 = string.lastIndexOf(",");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string.trim();
    }
}

