/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.tech.bean.request.OfflineCreateAuthParam;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.enums.ContactType;
import esign.utils.exception.SuperException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OnlineCreateAuthParam
extends OfflineCreateAuthParam {
    private String contact;
    private Boolean sendNotice = true;
    private String redirectUrl;

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public boolean isSendNotice() {
        return this.sendNotice;
    }

    public void setSendNotice(boolean sendNotice) {
        this.sendNotice = sendNotice;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public void check() throws SuperException {
        super.check();
        this.checkContact();
    }

    private void checkContact() throws SuperException {
        if (StringUtils.isBlank((String)this.contact)) {
            throw ErrorCode.PARAM_ERROR.e("contact\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OnlineCreateAuthParam.isPhoneNumber(this.contact) && !OnlineCreateAuthParam.isEmailAddress(this.contact)) {
            throw ErrorCode.PARAM_ERROR.e("contact\u8054\u7cfb\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef");
        }
    }

    public static boolean isPhoneNumber(String input) {
        String string = "1[3-9]\\d{9}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static boolean isEmailAddress(String input) {
        String string = "\\w+@[\\w&&[^_]]{2,6}(\\.[a-zA-Z]{2,3}){1,2}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public int getContactType() {
        if (OnlineCreateAuthParam.isPhoneNumber(this.contact)) {
            return ContactType.PHONE_NUMBER.getType();
        }
        return ContactType.EMAIL.getType();
    }
}

