/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.ec.h;
import com.timevale.esign.paas.tech.util.SM2Helper;
import com.timevale.esign.paas.tech.util.SignatureProperties;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class SM2SignatureProperties
extends SignatureProperties {
    public SM2SignatureProperties(byte[] privateKeyBytes, byte[] certificateBytes) {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            if (privateKeyBytes.length > 0) {
                this.privateKey = new h(new BigInteger(privateKeyBytes));
            }
            if (certificateBytes.length > 0) {
                byteArrayInputStream = new ByteArrayInputStream(certificateBytes);
                filterInputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1InputStream)filterInputStream).readObject();
                this.certificate = Certificate.getInstance(aSN1Sequence);
                this.publicKey = SM2Helper.parsePublicKey(this.certificate);
            }
            this.provider = "SM";
            this.signatureAlgorithm = "SM3WithSM2";
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

