/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.gm.b;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSequence;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignerInfo;
import java.util.Enumeration;

public class d
extends ASN1Object {
    private static final ASN1Integer VERSION_1 = new ASN1Integer(1L);
    private static final ASN1Integer VERSION_3 = new ASN1Integer(3L);
    private static final ASN1Integer VERSION_4 = new ASN1Integer(4L);
    private static final ASN1Integer VERSION_5 = new ASN1Integer(5L);
    private ASN1Integer version;
    private ASN1Set digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;
    private boolean certsBer;
    private boolean crlsBer;

    public static d bi(Object object) {
        if (object instanceof d) {
            return (d)object;
        }
        if (object != null) {
            return new d(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public d(ASN1Set aSN1Set, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1Set aSN1Set3, ASN1Set aSN1Set4) {
        this.version = this.calculateVersion(contentInfo.getContentType(), aSN1Set2, aSN1Set3, aSN1Set4);
        this.digestAlgorithms = aSN1Set;
        this.contentInfo = contentInfo;
        this.certificates = aSN1Set2;
        this.crls = aSN1Set3;
        this.signerInfos = aSN1Set4;
        this.crlsBer = aSN1Set3 instanceof BERSet;
        this.certsBer = aSN1Set2 instanceof BERSet;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier paramASN1ObjectIdentifier, ASN1Set paramASN1Set1, ASN1Set paramASN1Set2, ASN1Set paramASN1Set3) {
        Object e2;
        Enumeration enumeration;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (paramASN1Set1 != null) {
            enumeration = paramASN1Set1.getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(e2);
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl5 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (paramASN1Set2 != null) {
            enumeration = paramASN1Set2.getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            return VERSION_5;
        }
        if (bl5) {
            return VERSION_4;
        }
        if (bl4) {
            return VERSION_3;
        }
        if (this.checkForVersion3(paramASN1Set3)) {
            return VERSION_3;
        }
        if (!CMSObjectIdentifiers.data.equals(paramASN1ObjectIdentifier)) {
            return VERSION_3;
        }
        return VERSION_1;
    }

    private boolean checkForVersion3(ASN1Set paramASN1Set) {
        Enumeration enumeration = paramASN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private d(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement());
        this.digestAlgorithms = (ASN1Set)enumeration.nextElement();
        this.contentInfo = ContentInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.certsBer = aSN1TaggedObject instanceof BERTaggedObject;
                        this.certificates = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.crlsBer = aSN1TaggedObject instanceof BERTaggedObject;
                        this.crls = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + aSN1TaggedObject.getTagNo());
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)aSN1Primitive;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo getEncapContentInfo() {
        return this.contentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithms);
        aSN1EncodableVector.add(this.contentInfo);
        if (this.certificates != null) {
            if (this.certsBer) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 0, this.certificates));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.certificates));
            }
        }
        if (this.crls != null) {
            if (this.crlsBer) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 1, this.crls));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.crls));
            }
        }
        aSN1EncodableVector.add(this.signerInfos);
        return new BERSequence(aSN1EncodableVector);
    }
}

