/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.collect.AbstractMapEntry;
import com.timevale.guava.common.collect.ForwardingMap;
import com.timevale.guava.common.collect.Sets;
import java.util.Map;
import java.util.Set;

@GwtCompatible
final class WellBehavedMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private Set<Map.Entry<K, V>> entrySet;

    private WellBehavedMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    static <K, V> WellBehavedMap<K, V> wrap(Map<K, V> delegate) {
        return new WellBehavedMap<K, V>(delegate);
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = Sets.transform(this.delegate.keySet(), new KeyToEntryConverter(this));
        return this.entrySet;
    }

    private static class KeyToEntryConverter<K, V>
    extends Sets.InvertibleFunction<K, Map.Entry<K, V>> {
        final Map<K, V> map;

        KeyToEntryConverter(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Map.Entry<K, V> apply(final K key) {
            return new AbstractMapEntry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return map.get(key);
                }

                @Override
                public V setValue(V value) {
                    return map.put(key, value);
                }
            };
        }

        @Override
        public K invert(Map.Entry<K, V> entry) {
            return entry.getKey();
        }
    }
}

